/*
 * Decompiled with CFR 0.152.
 */
package io.github.lumine1909.custombiomecolors.util;

import io.github.lumine1909.custombiomecolors.util.BiomeColorUtil;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public class MessageUtil {
    public static Component getColorMessage(int color) {
        return MessageUtil.getColorMessage(color, false);
    }

    private static Component getColorMessage(int color, boolean isDefault) {
        int realColor = color & 0xFFFFFF;
        TextComponent colorMessage = Component.text((String)String.format("#%06X", realColor), (TextColor)TextColor.color((int)realColor));
        return isDefault ? colorMessage.append((Component)Component.text((String)" (Default)", (TextColor)NamedTextColor.GRAY)) : colorMessage;
    }

    public static Component getColorMessageGrass(Optional<Integer> color, float temperature, float downfall) {
        if (color.isPresent()) {
            return MessageUtil.getColorMessage(color.get(), false);
        }
        int realColor = BiomeColorUtil.getGrassColor(temperature, downfall);
        return MessageUtil.getColorMessage(realColor, true);
    }

    public static Component getColorMessageFoliage(Optional<Integer> color, float temperature, float downfall) {
        if (color.isPresent()) {
            return MessageUtil.getColorMessage(color.get(), false);
        }
        int realColor = BiomeColorUtil.getFoliageColor(temperature, downfall);
        return MessageUtil.getColorMessage(realColor, true);
    }

    public static Component getColorMessageDryFoliage(Optional<Integer> color, float temperature, float downfall) {
        if (color.isPresent()) {
            return MessageUtil.getColorMessage(color.get(), false);
        }
        int realColor = BiomeColorUtil.getDryFoliageColor(temperature, downfall);
        return MessageUtil.getColorMessage(realColor, true);
    }
}

