/*
 * Decompiled with CFR 0.152.
 */
package io.github.lumine1909.custombiomecolors.util.object;

import io.github.lumine1909.custombiomecolors.util.object.BiomeColorType;
import java.util.Optional;

public record ColorData(int fogColor, int waterColor, int waterFogColor, int skyColor, Optional<Integer> foliageColor, Optional<Integer> dryFoliageColor, Optional<Integer> grassColor) {
    public ColorData setColor(BiomeColorType colorType, int color) {
        return switch (colorType) {
            default -> throw new MatchException(null, null);
            case BiomeColorType.GRASS -> this.setGrassColor(color);
            case BiomeColorType.FOLIAGE -> this.setFoliageColor(color);
            case BiomeColorType.WATER -> this.setWaterColor(color);
            case BiomeColorType.WATER_FOG -> this.setWaterFogColor(color);
            case BiomeColorType.SKY -> this.setSkyColor(color);
            case BiomeColorType.FOG -> this.setFogColor(color);
            case BiomeColorType.DRY_FOLIAGE -> this.setDryFoliageColor(color);
        };
    }

    private Mutable mutable() {
        return new Mutable(this.fogColor, this.waterColor, this.waterFogColor, this.skyColor, this.foliageColor, this.dryFoliageColor, this.grassColor);
    }

    public ColorData setGrassColor(int grassColor) {
        return this.mutable().grass(Optional.of(grassColor)).build();
    }

    public ColorData setFoliageColor(int foliageColor) {
        return this.mutable().foliage(Optional.of(foliageColor)).build();
    }

    public ColorData setDryFoliageColor(int dryFoliageColor) {
        return this.mutable().dryFoliage(Optional.of(dryFoliageColor)).build();
    }

    public ColorData setWaterColor(int waterColor) {
        return this.mutable().water(waterColor).build();
    }

    public ColorData setWaterFogColor(int waterFogColor) {
        return this.mutable().waterFog(waterFogColor).build();
    }

    public ColorData setSkyColor(int skyColor) {
        return this.mutable().sky(skyColor).build();
    }

    public ColorData setFogColor(int fogColor) {
        return this.mutable().fog(fogColor).build();
    }

    public static class Mutable {
        private int fogColor;
        private int waterColor;
        private int waterFogColor;
        private int skyColor;
        private Optional<Integer> foliageColor = Optional.empty();
        private Optional<Integer> dryFoliageColor = Optional.empty();
        private Optional<Integer> grassColor = Optional.empty();

        public Mutable() {
        }

        public Mutable(int fogColor, int waterColor, int waterFogColor, int skyColor, Optional<Integer> foliageColor, Optional<Integer> dryFoliageColor, Optional<Integer> grassColor) {
            this.fogColor = fogColor;
            this.waterColor = waterColor;
            this.waterFogColor = waterFogColor;
            this.skyColor = skyColor;
            this.foliageColor = foliageColor;
            this.dryFoliageColor = dryFoliageColor;
            this.grassColor = grassColor;
        }

        public Mutable fog(int fogColor) {
            this.fogColor = fogColor;
            return this;
        }

        public Mutable water(int waterColor) {
            this.waterColor = waterColor;
            return this;
        }

        public Mutable waterFog(int waterFogColor) {
            this.waterFogColor = waterFogColor;
            return this;
        }

        public Mutable sky(int skyColor) {
            this.skyColor = skyColor;
            return this;
        }

        public Mutable foliage(Optional<Integer> foliageColor) {
            this.foliageColor = foliageColor;
            return this;
        }

        public Mutable dryFoliage(Optional<Integer> dryFoliageColor) {
            this.dryFoliageColor = dryFoliageColor;
            return this;
        }

        public Mutable grass(Optional<Integer> grassColor) {
            this.grassColor = grassColor;
            return this;
        }

        public ColorData build() {
            return new ColorData(this.fogColor, this.waterColor, this.waterFogColor, this.skyColor, this.foliageColor, this.dryFoliageColor, this.grassColor);
        }
    }
}

