/*
 * Decompiled with CFR 0.152.
 */
package me.decce.gnetum;

import java.util.Arrays;
import me.decce.gnetum.Gnetum;
import net.minecraft.client.Minecraft;

public class HudDeltaTracker {
    private static float lastTickDelta = Float.NaN;
    private static float[] tickDeltas;

    public static void update(Minecraft minecraft) {
        int len = Gnetum.config.numberOfPasses + 1;
        int curr = Gnetum.passManager.current;
        if (tickDeltas == null || tickDeltas.length != len) {
            HudDeltaTracker.reset();
        }
        int n = curr;
        tickDeltas[n] = tickDeltas[n] + minecraft.m_91297_();
    }

    public static void reset() {
        int len = Gnetum.config.numberOfPasses + 1;
        if (tickDeltas == null || tickDeltas.length != len) {
            tickDeltas = new float[len];
        } else {
            HudDeltaTracker.store();
        }
        Arrays.fill(tickDeltas, 0.0f);
    }

    private static void store() {
        lastTickDelta = 0.0f;
        for (int i = 0; i <= Gnetum.config.numberOfPasses; ++i) {
            if (i >= tickDeltas.length) continue;
            lastTickDelta += tickDeltas[i];
        }
    }

    public static boolean isReady() {
        return !Float.isNaN(lastTickDelta);
    }

    public static float getTickDelta() {
        return lastTickDelta;
    }
}

