/*
 * Decompiled with CFR 0.152.
 */
package me.decce.gnetum;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.HashMap;
import me.decce.gnetum.CacheSetting;
import me.decce.gnetum.ElementType;
import me.decce.gnetum.Gnetum;
import me.decce.gnetum.GuiHelper;
import me.decce.gnetum.PackedVanillaElements;
import me.decce.gnetum.PerformanceAnalyzer;
import me.decce.gnetum.mixins.GuiLayerManagerAccessor;
import me.decce.gnetum.util.AnyBooleanValue;
import me.decce.gnetum.util.TriStateBoolean;
import me.decce.gnetum.util.TwoStateBoolean;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLPaths;

public class GnetumConfig {
    public static final int UNLIMITED_FPS = 125;
    private static final Path PATH = FMLPaths.CONFIGDIR.get().resolve("gnetum.json");
    public TwoStateBoolean enabled = new TwoStateBoolean(AnyBooleanValue.ON);
    public TwoStateBoolean showHudFps = new TwoStateBoolean(AnyBooleanValue.ON);
    public int numberOfPasses = 3;
    public int maxFps = 60;
    public HashMap<String, CacheSetting> mapVanillaElements = new HashMap();
    public HashMap<String, CacheSetting> mapModdedElementsPre = new HashMap();
    public HashMap<String, CacheSetting> mapModdedElementsPost = new HashMap();

    public boolean isEnabled() {
        return this.enabled.get();
    }

    private static GnetumConfig createDefault() {
        GnetumConfig config = new GnetumConfig();
        config.mapVanillaElements.put("gnetum:minecraft_hand", new CacheSetting(1, new TriStateBoolean(AnyBooleanValue.AUTO, false)));
        return config;
    }

    private static GnetumConfig load() {
        try {
            if (!Files.exists(PATH, new LinkOption[0])) {
                return GnetumConfig.createDefault();
            }
            String json = Files.readString(PATH);
            Gson gson = new Gson();
            GnetumConfig config = (GnetumConfig)gson.fromJson(json, GnetumConfig.class);
            if (!config.mapVanillaElements.containsKey("gnetum:minecraft_hand")) {
                config.mapVanillaElements.put("gnetum:minecraft_hand", new CacheSetting(1, new TriStateBoolean(AnyBooleanValue.AUTO, false)));
            }
            config.mapVanillaElements.get((Object)"gnetum:minecraft_hand").enabled.defaultValue = false;
            config.validate();
            return config;
        }
        catch (IOException e) {
            Gnetum.LOGGER.error("Failed to read configuration!", (Throwable)e);
            return GnetumConfig.createDefault();
        }
    }

    public void validate() {
        this.numberOfPasses = GnetumConfig.clamp(this.numberOfPasses, 2, 10);
        this.mapVanillaElements.forEach((s, c) -> {
            c.pass = GnetumConfig.clamp(c.pass, 1, this.numberOfPasses);
        });
        this.mapModdedElementsPre.forEach((s, c) -> {
            c.pass = GnetumConfig.clamp(c.pass, 1, this.numberOfPasses);
        });
        this.mapModdedElementsPost.forEach((s, c) -> {
            c.pass = GnetumConfig.clamp(c.pass, 1, this.numberOfPasses);
        });
        this.maxFps = GnetumConfig.clamp(this.maxFps, 1, 125);
        this.hideElementsOrphanOrUncached();
        this.removeObsoleteVanillaElements();
    }

    private void hideElementsOrphanOrUncached() {
        this.mapModdedElementsPre.entrySet().stream().filter(entry -> !ModList.get().isLoaded((String)entry.getKey()) || Gnetum.uncachedElements.has((String)entry.getKey(), ElementType.PRE)).forEach(entry -> {
            ((CacheSetting)entry.getValue()).hidden = true;
        });
        this.mapModdedElementsPost.entrySet().stream().filter(entry -> !ModList.get().isLoaded((String)entry.getKey()) || Gnetum.uncachedElements.has((String)entry.getKey(), ElementType.POST)).forEach(entry -> {
            ((CacheSetting)entry.getValue()).hidden = true;
        });
        GuiLayerManagerAccessor accessor = GuiHelper.getGuiLayerManagerAccessor();
        this.mapVanillaElements.forEach((s, c) -> {
            if (s.startsWith("gnetum")) {
                return;
            }
            if (Gnetum.uncachedElements.has((String)s) || accessor.getLayers().stream().noneMatch(layer -> layer.name().toString().equals(s))) {
                c.hidden = true;
            }
        });
    }

    private void removeObsoleteVanillaElements() {
        PackedVanillaElements.getMap().forEach((key, value) -> Arrays.stream(value.getOverlays()).forEach(key1 -> this.mapVanillaElements.remove(key1)));
    }

    private static int clamp(int value, int min, int max) {
        return Math.max(Math.min(value, max), min);
    }

    public static void reload() {
        Gnetum.config = GnetumConfig.load();
    }

    public static void reset() {
        Gnetum.config = GnetumConfig.createDefault();
        Gnetum.config.save();
    }

    public void save() {
        this.validate();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson((Object)this);
        try {
            Files.writeString(PATH, (CharSequence)json, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            Gnetum.LOGGER.error("Failed to save config file!", (Throwable)e);
        }
        if (PerformanceAnalyzer.latestAnalysisResult != null) {
            PerformanceAnalyzer.latestAnalysisResult.markOutdated();
        }
    }
}

