/*
 * Decompiled with CFR 0.152.
 */
package me.decce.gnetum;

import me.decce.gnetum.Gnetum;
import net.minecraft.client.DeltaTracker;

public class HudDeltaTracker {
    private static float[] gameTimeDeltaTicks;
    private static float[] gameTimeDeltaPartialTick;
    private static float[] realtimeDeltaTicks;

    public static void update(DeltaTracker.Timer timer) {
        int len = Gnetum.config.numberOfPasses + 1;
        int curr = Gnetum.passManager.current;
        if (gameTimeDeltaTicks == null || gameTimeDeltaTicks.length != len) {
            gameTimeDeltaTicks = new float[len];
            gameTimeDeltaPartialTick = new float[len];
            realtimeDeltaTicks = new float[len];
        }
        int n = curr;
        gameTimeDeltaTicks[n] = gameTimeDeltaTicks[n] + timer.getGameTimeDeltaTicks();
        int n2 = curr;
        gameTimeDeltaPartialTick[n2] = gameTimeDeltaPartialTick[n2] + timer.getGameTimeDeltaPartialTick(true);
        int n3 = curr;
        realtimeDeltaTicks[n3] = realtimeDeltaTicks[n3] + timer.getRealtimeDeltaTicks();
    }

    public static void reset() {
        int len = Gnetum.config.numberOfPasses + 1;
        if (gameTimeDeltaTicks == null || gameTimeDeltaTicks.length != len) {
            gameTimeDeltaTicks = new float[len];
            gameTimeDeltaPartialTick = new float[len];
            realtimeDeltaTicks = new float[len];
        }
        for (int i = 0; i < len; ++i) {
            HudDeltaTracker.reset(i);
        }
    }

    public static void reset(int i) {
        HudDeltaTracker.gameTimeDeltaTicks[i] = 0.0f;
        HudDeltaTracker.gameTimeDeltaPartialTick[i] = 0.0f;
        HudDeltaTracker.realtimeDeltaTicks[i] = 0.0f;
    }

    public static void step() {
        int len = Gnetum.config.numberOfPasses + 1;
        if (gameTimeDeltaTicks == null || gameTimeDeltaTicks.length != len) {
            HudDeltaTracker.reset();
        }
        int i = Gnetum.passManager.current;
        HudDeltaTracker.reset(i);
    }

    public static float getGameTimeDeltaTicks() {
        float ret = 0.0f;
        for (int i = 0; i <= Gnetum.config.numberOfPasses; ++i) {
            if (i >= gameTimeDeltaTicks.length) continue;
            ret += gameTimeDeltaTicks[i];
        }
        return ret;
    }

    public static float getGameTimeDeltaPartialTick() {
        float ret = 0.0f;
        for (int i = 0; i <= Gnetum.config.numberOfPasses; ++i) {
            if (i >= gameTimeDeltaPartialTick.length) continue;
            ret += gameTimeDeltaPartialTick[i];
        }
        return ret;
    }

    public static float getRealtimeDeltaTicks() {
        float ret = 0.0f;
        for (int i = 0; i <= Gnetum.config.numberOfPasses; ++i) {
            if (i >= realtimeDeltaTicks.length) continue;
            ret += realtimeDeltaTicks[i];
        }
        return ret;
    }
}

