/*
 * Decompiled with CFR 0.152.
 */
package me.decce.gnetum;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.HashMap;
import java.util.List;
import me.decce.gnetum.CacheSetting;
import me.decce.gnetum.ElementType;
import me.decce.gnetum.FpsCounter;
import me.decce.gnetum.FramebufferManager;
import me.decce.gnetum.GnetumConfig;
import me.decce.gnetum.GnetumConfigScreenFactory;
import me.decce.gnetum.PackedVanillaElements;
import me.decce.gnetum.PassManager;
import me.decce.gnetum.PerformanceAnalyzer;
import me.decce.gnetum.SuggestedPass;
import me.decce.gnetum.UncachedElements;
import me.decce.gnetum.gui.ConfigScreen;
import me.decce.gnetum.util.AnyBooleanValue;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.javafmlmod.FMLModContainer;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.CustomizeGuiOverlayEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.Lazy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="gnetum", dist={Dist.CLIENT})
public final class Gnetum {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "gnetum";
    public static final String HAND_ELEMENT = "gnetum:minecraft_hand";
    public static final String OTHER_MODS = "gnetum_unknown";
    public static final FpsCounter FPS_COUNTER = new FpsCounter();
    public static GnetumConfig config;
    public static PassManager passManager;
    public static UncachedElements uncachedElements;
    public static String currentElement;
    public static ElementType currentElementType;
    public static long lastSwapNanos;
    public static boolean rendering;
    public static boolean renderingCanceled;
    public static final Lazy<KeyMapping> CONFIG_MAPPING;

    public Gnetum(FMLModContainer container, IEventBus modBus, Dist dist) {
        modBus.addListener(Gnetum::registerBindings);
        NeoForge.EVENT_BUS.addListener(this::onClientTick);
        NeoForge.EVENT_BUS.addListener(this::onCustomizeF3Text);
        NeoForge.EVENT_BUS.addListener(this::onPlayerJoin);
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)new GnetumConfigScreenFactory());
    }

    public static GnetumConfig getConfig() {
        if (config == null) {
            Gnetum.ensureInitialized();
        }
        return config;
    }

    public static void ensureInitialized() {
        if (passManager == null) {
            passManager = new PassManager();
            uncachedElements = new UncachedElements();
        }
        GnetumConfig.reload();
    }

    public static CacheSetting getCacheSetting(String vanillaOverlay) {
        if (!Gnetum.config.mapVanillaElements.containsKey(vanillaOverlay = PackedVanillaElements.consider(vanillaOverlay))) {
            Gnetum.config.mapVanillaElements.put(vanillaOverlay, new CacheSetting(SuggestedPass.get(vanillaOverlay)));
        }
        return Gnetum.config.mapVanillaElements.get(vanillaOverlay);
    }

    public static CacheSetting getCacheSetting(String moddedOverlay, ElementType type) {
        HashMap<String, CacheSetting> map;
        if (type == ElementType.VANILLA) {
            return Gnetum.getCacheSetting(moddedOverlay);
        }
        HashMap<String, CacheSetting> hashMap = map = type == ElementType.PRE ? Gnetum.config.mapModdedElementsPre : Gnetum.config.mapModdedElementsPost;
        if (!map.containsKey(moddedOverlay)) {
            map.put(moddedOverlay, new CacheSetting(type == ElementType.PRE ? 1 : Gnetum.config.numberOfPasses));
        }
        return map.get(moddedOverlay);
    }

    public static void disableCachingForCurrentElement(String reason) {
        if (currentElement == null || currentElementType == null) {
            return;
        }
        CacheSetting cacheSetting = Gnetum.getCacheSetting(currentElement, currentElementType);
        if (cacheSetting.enabled.get() && cacheSetting.enabled.value == AnyBooleanValue.AUTO) {
            LOGGER.info("Disabling caching for element {}. Reason: {}", (Object)currentElement, (Object)reason);
            cacheSetting.enabled.defaultValue = false;
            FramebufferManager.getInstance().dropCurrentFrame();
        }
    }

    public static void registerBindings(RegisterKeyMappingsEvent event) {
        event.register((KeyMapping)CONFIG_MAPPING.get());
    }

    public void onClientTick(ClientTickEvent.Post event) {
        while (((KeyMapping)CONFIG_MAPPING.get()).consumeClick()) {
            if (Minecraft.getInstance().screen instanceof ConfigScreen) continue;
            Minecraft.getInstance().setScreen((Screen)new ConfigScreen(PerformanceAnalyzer.analyze()));
        }
    }

    public void onCustomizeF3Text(CustomizeGuiOverlayEvent.DebugText event) {
        List left;
        if (config.isEnabled() && Gnetum.config.showHudFps.get() && Minecraft.getInstance().getDebugOverlay().showDebugScreen() && (left = event.getLeft()).size() > 2) {
            event.getLeft().add(2, String.format("HUD: %d fps (%d passes, max %s)", FPS_COUNTER.getFps(), Gnetum.config.numberOfPasses, Gnetum.config.maxFps == 125 ? "unlimited" : Integer.valueOf(Gnetum.config.maxFps)));
        }
    }

    public void onPlayerJoin(ClientPlayerNetworkEvent.LoggingIn event) {
        Gnetum.ensureInitialized();
        FPS_COUNTER.reset();
        FramebufferManager.getInstance().reset();
        PackedVanillaElements.reset();
    }

    static {
        CONFIG_MAPPING = Lazy.of(() -> new KeyMapping("gnetum.config.keyMapping", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 269, "key.categories.misc"));
    }
}

