/*
 * Decompiled with CFR 0.152.
 */
package me.decce.gnetum.gui;

import java.util.Objects;
import java.util.function.Supplier;
import me.decce.gnetum.gui.BaseScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;

public class ConfirmationScreen
extends BaseScreen {
    private Runnable action;
    private Supplier<Screen> parentYes;
    private Supplier<Screen> parentNo;

    public ConfirmationScreen(Supplier<Screen> parentYes, Supplier<Screen> parentNo, Runnable action) {
        this.action = action;
        this.parentYes = parentYes;
        this.parentNo = parentNo;
    }

    @Override
    protected void rebuild() {
        this.clearWidgets();
        int w = 100;
        int h = 20;
        int m = 20;
        String txt = I18n.get((String)"gnetum.config.confirmReset", (Object[])new Object[0]);
        int n = this.width / 2 - 150;
        int n2 = this.height / 2;
        Objects.requireNonNull(this.font);
        MultiLineTextWidget stringWidget = new MultiLineTextWidget(n, n2 - 9 * 4, (Component)Component.literal((String)txt), this.font);
        stringWidget.setMaxWidth(300);
        Button btnYes = Button.builder((Component)Component.translatable((String)"gui.yes"), b -> this.onYes()).pos(this.width / 2 - w - m, this.height / 2 + 90).size(w, h).build();
        Button btnNo = Button.builder((Component)Component.translatable((String)"gui.no"), b -> this.onNo()).pos(this.width / 2 + m, this.height / 2 + 90).size(w, h).build();
        this.addRenderableWidget((GuiEventListener)stringWidget);
        this.addRenderableWidget((GuiEventListener)btnYes);
        this.addRenderableWidget((GuiEventListener)btnNo);
    }

    protected void onYes() {
        this.action.run();
        Minecraft.getInstance().setScreen(this.parentYes.get());
    }

    protected void onNo() {
        Minecraft.getInstance().setScreen(this.parentNo.get());
    }
}

