/*
 * Decompiled with CFR 0.152.
 */
package me.decce.gnetum.mixins;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.platform.GlStateManager;
import me.decce.gnetum.ElementType;
import me.decce.gnetum.FramebufferManager;
import me.decce.gnetum.Gnetum;
import me.decce.gnetum.GuiHelper;
import me.decce.gnetum.HudDeltaTracker;
import me.decce.gnetum.compat.immediatelyfast.ImmediatelyFastCompat;
import me.decce.gnetum.compat.journeymap.JourneyMapCompat;
import me.decce.gnetum.compat.pingwheel.PingWheelCompat;
import me.decce.gnetum.gl.FramebufferTracker;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class}, priority=1500)
public class GameRendererMixin {
    @Unique
    private int gnetum$previouslyBoundFbo;
    @Unique
    private boolean gnetum$renderingCachedHand;
    @Unique
    private boolean gnetum$wasChatScreenOpen;

    @Inject(method={"renderItemInHand"}, at={@At(value="HEAD")}, cancellable=true)
    private void gnetum$preRenderItemInHand(Camera camera, float partialTick, Matrix4f projectionMatrix, CallbackInfo ci) {
        if (!Gnetum.config.isEnabled() || Gnetum.passManager.cachingDisabled("gnetum:minecraft_hand")) {
            return;
        }
        if (Gnetum.passManager.shouldRender("gnetum:minecraft_hand")) {
            this.gnetum$previouslyBoundFbo = FramebufferTracker.getCurrentlyBoundFbo();
            Gnetum.passManager.begin();
            FramebufferManager.getInstance().bind();
            this.gnetum$renderingCachedHand = true;
        } else {
            ci.cancel();
        }
    }

    @Inject(method={"renderItemInHand"}, at={@At(value="RETURN")})
    private void gnetum$postRenderItemInHand(Camera camera, float partialTick, Matrix4f projectionMatrix, CallbackInfo ci) {
        if (this.gnetum$renderingCachedHand) {
            this.gnetum$renderingCachedHand = false;
            GlStateManager._glBindFramebuffer((int)36160, (int)this.gnetum$previouslyBoundFbo);
            Gnetum.passManager.end();
        }
    }

    @WrapOperation(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/Gui;render(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/DeltaTracker;)V")})
    private void gnetum$wrapGuiRender(Gui instance, GuiGraphics guiGraphics, DeltaTracker deltaTracker, Operation<Void> original) {
        boolean needsCatchUp;
        if (!Gnetum.config.isEnabled() || Minecraft.getInstance().options.hideGui) {
            original.call(new Object[]{instance, guiGraphics, deltaTracker});
            return;
        }
        guiGraphics.pose().pushPose();
        FramebufferManager.getInstance().ensureSize();
        boolean chatScreenOpen = Minecraft.getInstance().screen instanceof ChatScreen;
        if (chatScreenOpen != this.gnetum$wasChatScreenOpen) {
            this.gnetum$wasChatScreenOpen = chatScreenOpen;
            FramebufferManager.getInstance().markForCatchUp();
        }
        if (!(needsCatchUp = FramebufferManager.getInstance().needsCatchUp())) {
            Minecraft.getInstance().getProfiler().push("uncached");
            ImmediatelyFastCompat.batchIfInstalled(guiGraphics, () -> {
                JourneyMapCompat.invokeRenderWaypointDecos(guiGraphics);
                PingWheelCompat.invokeRenderGUI(guiGraphics, deltaTracker.getGameTimeDeltaPartialTick(true));
                GuiHelper.postEvent(new RenderGuiEvent.Pre(guiGraphics, deltaTracker), guiGraphics.pose(), modid -> Gnetum.passManager.cachingDisabled((String)modid, ElementType.PRE));
                GuiHelper.renderLayers(GuiHelper.getGuiLayerManagerAccessor().getLayers(), guiGraphics, deltaTracker, overlay -> Gnetum.passManager.cachingDisabled((String)overlay));
            });
            Minecraft.getInstance().getProfiler().pop();
        }
        Gnetum.passManager.begin();
        if (deltaTracker instanceof DeltaTracker.Timer) {
            DeltaTracker.Timer timer = (DeltaTracker.Timer)deltaTracker;
            HudDeltaTracker.update(timer);
        } else {
            HudDeltaTracker.disable();
        }
        if (Gnetum.passManager.current > 0) {
            FramebufferManager.getInstance().bind();
        }
        Gnetum.rendering = true;
        original.call(new Object[]{instance, guiGraphics, deltaTracker});
        guiGraphics.flush();
        Gnetum.rendering = false;
        Gnetum.currentElement = null;
        Gnetum.passManager.end();
        Gnetum.passManager.nextPass();
        FramebufferManager.getInstance().unbind();
        boolean needsCatchUpAfterRendering = FramebufferManager.getInstance().needsCatchUp();
        if (!needsCatchUp && !needsCatchUpAfterRendering) {
            FramebufferManager.getInstance().blit();
            Minecraft.getInstance().getProfiler().push("uncached");
            ImmediatelyFastCompat.batchIfInstalled(guiGraphics, () -> GuiHelper.postEvent(new RenderGuiEvent.Post(guiGraphics, deltaTracker), guiGraphics.pose(), modid -> Gnetum.passManager.cachingDisabled((String)modid, ElementType.POST)));
            Minecraft.getInstance().getProfiler().pop();
        } else {
            original.call(new Object[]{instance, guiGraphics, deltaTracker});
        }
        guiGraphics.pose().popPose();
    }
}

