/*
 * Decompiled with CFR 0.152.
 */
package me.decce.gnetum.mixins;

import com.mojang.blaze3d.platform.GlStateManager;
import me.decce.gnetum.ElementType;
import me.decce.gnetum.FramebufferManager;
import me.decce.gnetum.Gnetum;
import me.decce.gnetum.gl.FramebufferTracker;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GlStateManager.class})
public class GlStateManagerMixin {
    @Inject(method={"_glBindFramebuffer"}, at={@At(value="TAIL")})
    private static void gnetum$bindFramebuffer(int target, int framebuffer, CallbackInfo ci) {
        if (target == 36160) {
            FramebufferTracker.setCurrentlyBoundFbo(framebuffer);
        }
    }

    @Inject(method={"_blendFunc(II)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void gnetum$blendFunc(int srcFactor, int dstFactor, CallbackInfo ci) {
        if (Gnetum.rendering) {
            GlStateManager._blendFuncSeparate((int)srcFactor, (int)dstFactor, (int)1, (int)771);
            ci.cancel();
        }
    }

    @Inject(method={"_blendFuncSeparate(IIII)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void gnetum$tryBlendFuncSeparate(int srcFactor, int dstFactor, int srcFactorAlpha, int dstFactorAlpha, CallbackInfo ci) {
        if (!Gnetum.rendering) {
            return;
        }
        if (srcFactorAlpha != 1 || dstFactorAlpha != 771) {
            GlStateManager._blendFuncSeparate((int)srcFactor, (int)dstFactor, (int)1, (int)771);
            ci.cancel();
            return;
        }
        if (FramebufferTracker.getCurrentlyBoundFbo() == FramebufferManager.getInstance().id() && GlStateManagerMixin.gnetum$isBlendFuncDangerous(srcFactor, dstFactor, srcFactorAlpha, dstFactorAlpha) && (Gnetum.currentElementType != ElementType.VANILLA || !"xaerominimap:xaero".equals(Gnetum.currentElement))) {
            Gnetum.disableCachingForCurrentElement(String.format("Blending Function (%d, %d, %d, %d)", srcFactor, dstFactor, srcFactorAlpha, dstFactorAlpha));
        }
    }

    @Unique
    private static boolean gnetum$isBlendFuncDangerous(int srcFactor, int dstFactor, int srcFactorAlpha, int dstFactorAlpha) {
        if (GlStateManagerMixin.gnetum$isUsingDestColor(srcFactor) || GlStateManagerMixin.gnetum$isUsingDestColor(dstFactor)) {
            return true;
        }
        return dstFactor == 768 || dstFactor == 769;
    }

    @Unique
    private static boolean gnetum$isUsingDestColor(int factor) {
        return factor == 774 || factor == 775;
    }
}

