/*
 * Decompiled with CFR 0.152.
 */
package me.decce.gnetum;

import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import net.neoforged.bus.ConsumerEventHandler;
import net.neoforged.bus.SubscribeEventListener;
import net.neoforged.bus.api.EventListener;

public class EventListenerHelper {
    private static final ReferenceSet<EventListener> invalid = new ReferenceOpenHashSet(0);
    private static final Reference2ObjectMap<EventListener, String> mapModId = new Reference2ObjectOpenHashMap();

    public static String tryGetModId(EventListener listener) {
        if (mapModId.containsKey((Object)listener)) {
            return (String)mapModId.get((Object)listener);
        }
        if (invalid.contains((Object)listener)) {
            return null;
        }
        Class<?> clazz = EventListenerHelper.tryGetClass(listener);
        if (clazz == null) {
            invalid.add((Object)listener);
            return null;
        }
        Module module = clazz.getModule();
        if (module.isNamed()) {
            String modid = module.getName();
            mapModId.put((Object)listener, (Object)modid);
            return modid;
        }
        invalid.add((Object)listener);
        return null;
    }

    private static Class<?> tryGetClass(EventListener listener) {
        if (listener instanceof SubscribeEventListener) {
            String name = listener.toString().substring("@SubscribeEvent: ".length());
            if (name.startsWith("class ")) {
                int index = (name = name.substring("class ".length())).indexOf(32);
                if (index == -1) {
                    return null;
                }
                name = name.substring(0, index);
                return EventListenerHelper.tryClassForName(name);
            }
            if (name.contains("@")) {
                name = name.substring(0, name.indexOf(64));
                return EventListenerHelper.tryClassForName(name);
            }
        } else if (listener instanceof ConsumerEventHandler) {
            String name = listener.toString();
            int index = name.indexOf("$$");
            if (index == -1) {
                return null;
            }
            name = name.substring(0, index);
            return EventListenerHelper.tryClassForName(name);
        }
        return null;
    }

    private static Class<?> tryClassForName(String name) {
        try {
            return Class.forName(name);
        }
        catch (Throwable ignored) {
            return null;
        }
    }
}

