/*
 * Decompiled with CFR 0.152.
 */
package me.decce.gnetum;

import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexSorting;
import me.decce.gnetum.Gnetum;
import net.minecraft.client.Minecraft;
import net.neoforged.neoforge.client.ClientHooks;
import org.joml.Matrix4f;

public class FramebufferManager {
    private static final Minecraft mc = Minecraft.getInstance();
    private static final FramebufferManager instance = new FramebufferManager();
    private boolean dropCurrentFrame;
    private boolean complete;
    private boolean toBeComplete = true;
    private int width;
    private int height;
    private double guiScale;
    private TextureTarget backFramebuffer;
    private TextureTarget frontFramebuffer;

    private FramebufferManager() {
        this.reset();
    }

    public static FramebufferManager getInstance() {
        return instance;
    }

    public void ensureSize() {
        if (mc.getWindow().getWidth() != this.width || mc.getWindow().getHeight() != this.height || mc.getWindow().getGuiScale() != this.guiScale) {
            this.reset();
        }
    }

    public void clear() {
        this.clear(this.backFramebuffer);
    }

    public void clear(TextureTarget framebuffer) {
        mc.getProfiler().push("clear");
        framebuffer.clear(Minecraft.ON_OSX);
        mc.getProfiler().pop();
    }

    public void reset() {
        this.width = mc.getWindow().getWidth();
        this.height = mc.getWindow().getHeight();
        this.guiScale = mc.getWindow().getGuiScale();
        if (this.backFramebuffer != null) {
            this.backFramebuffer.destroyBuffers();
        }
        this.backFramebuffer = new TextureTarget(this.width, this.height, true, false);
        this.backFramebuffer.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.backFramebuffer.setFilterMode(9728);
        this.clear(this.backFramebuffer);
        if (this.frontFramebuffer != null) {
            this.frontFramebuffer.destroyBuffers();
        }
        this.frontFramebuffer = new TextureTarget(this.width, this.height, true, false);
        this.frontFramebuffer.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.frontFramebuffer.setFilterMode(9728);
        this.clear(this.frontFramebuffer);
        this.markIncomplete();
        Gnetum.passManager.current = 1;
    }

    public void bind(boolean setViewport) {
        this.backFramebuffer.bindWrite(setViewport);
    }

    public void bind() {
        this.bind(true);
    }

    public void unbind() {
        mc.getMainRenderTarget().bindWrite(true);
    }

    public void blit() {
        mc.getProfiler().push("blit");
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        RenderSystem.blendFuncSeparate((int)1, (int)771, (int)1, (int)771);
        this.frontFramebuffer.blitToScreen(this.width, this.height, false);
        Window window = mc.getWindow();
        Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, (float)((double)window.getWidth() / window.getGuiScale()), (float)((double)window.getHeight() / window.getGuiScale()), 0.0f, 1000.0f, ClientHooks.getGuiFarPlane());
        RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        mc.getProfiler().pop();
    }

    public void swapFramebuffers() {
        if (!this.dropCurrentFrame) {
            TextureTarget temp = this.backFramebuffer;
            this.backFramebuffer = this.frontFramebuffer;
            this.frontFramebuffer = temp;
            if (this.toBeComplete) {
                this.complete = true;
            } else {
                this.toBeComplete = true;
            }
            Gnetum.FPS_COUNTER.tick();
        }
        this.clear();
        this.dropCurrentFrame = false;
    }

    public void dropCurrentFrame() {
        this.dropCurrentFrame = true;
    }

    public int id() {
        return this.backFramebuffer.frameBufferId;
    }

    public void markIncomplete() {
        if (this.complete) {
            this.complete = false;
        } else {
            this.toBeComplete = false;
        }
    }

    public boolean isComplete() {
        return this.complete;
    }
}

