/*
 * Decompiled with CFR 0.152.
 */
package me.decce.gnetum;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.function.Predicate;
import me.decce.gnetum.ElementType;
import me.decce.gnetum.EventBusHelper;
import me.decce.gnetum.EventListenerHelper;
import me.decce.gnetum.Gnetum;
import me.decce.gnetum.mixins.GuiAccessor;
import me.decce.gnetum.mixins.GuiLayerManagerAccessor;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.neoforged.bus.ConsumerEventHandler;
import net.neoforged.bus.SubscribeEventListener;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventListener;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.GuiLayerManager;
import net.neoforged.neoforge.common.NeoForge;

public class GuiHelper {
    public static GuiAccessor getGuiAccessor() {
        return (GuiAccessor)Minecraft.getInstance().gui;
    }

    public static GuiLayerManagerAccessor getGuiLayerManagerAccessor() {
        return (GuiLayerManagerAccessor)GuiHelper.getGuiAccessor().getLayerManager();
    }

    public static void renderLayers(List<GuiLayerManager.NamedLayer> list, GuiGraphics guiGraphics, DeltaTracker partialTick, Predicate<String> check) {
        guiGraphics.pose().pushPose();
        for (int i = 0; i < list.size(); ++i) {
            GuiLayerManager.NamedLayer layer = list.get(i);
            String id = layer.name().toString();
            if (!check.test(id)) continue;
            if (Gnetum.rendering) {
                Gnetum.currentElement = id;
                Gnetum.currentElementType = ElementType.VANILLA;
            }
            if (!GuiHelper.pre(layer, guiGraphics, partialTick)) {
                layer.layer().render(guiGraphics, partialTick);
                GuiHelper.post(layer, guiGraphics, partialTick);
            }
            guiGraphics.pose().translate(0.0f, 0.0f, 200.0f);
            RenderSystem.enableDepthTest();
        }
        guiGraphics.pose().popPose();
    }

    public static boolean pre(GuiLayerManager.NamedLayer layer, GuiGraphics guiGraphics, DeltaTracker partialTick) {
        return ((RenderGuiLayerEvent.Pre)GuiHelper.postEvent((Event)new RenderGuiLayerEvent.Pre(guiGraphics, partialTick, layer.name(), layer.layer()))).isCanceled();
    }

    public static void post(GuiLayerManager.NamedLayer layer, GuiGraphics guiGraphics, DeltaTracker partialTick) {
        GuiHelper.postEvent((Event)new RenderGuiLayerEvent.Post(guiGraphics, partialTick, layer.name(), layer.layer()));
    }

    public static <T extends Event> T postEvent(Event event) {
        return (T)GuiHelper.postEvent(event, null);
    }

    public static <T extends Event> T postEvent(T event, Predicate<String> check) {
        int index;
        if (EventBusHelper.isShutdown()) {
            return event;
        }
        EventBusHelper.doPostChecks(event);
        EventListener[] listeners = EventBusHelper.getListenerList(event.getClass()).getListeners();
        try {
            for (index = 0; index < listeners.length; ++index) {
                EventListener listener = listeners[index];
                String modid = null;
                if (listener instanceof SubscribeEventListener || listener instanceof ConsumerEventHandler) {
                    modid = EventListenerHelper.tryGetModId(listener);
                }
                if (modid != null) {
                    if (event instanceof RenderGuiEvent.Pre) {
                        Gnetum.currentElement = modid;
                        Gnetum.currentElementType = ElementType.PRE;
                        if (check != null && !check.test(modid)) continue;
                        listener.invoke(event);
                        continue;
                    }
                    if (event instanceof RenderGuiEvent.Post) {
                        Gnetum.currentElement = modid;
                        Gnetum.currentElementType = ElementType.POST;
                        if (check != null && !check.test(modid)) continue;
                        listener.invoke(event);
                        continue;
                    }
                    listener.invoke(event);
                    continue;
                }
                if (Gnetum.rendering && !(event instanceof RenderGuiLayerEvent)) continue;
                listener.invoke(event);
            }
            return event;
        }
        catch (Throwable throwable) {
            EventBusHelper.getExceptionHandler().handleException(NeoForge.EVENT_BUS, event, listeners, index, throwable);
            throw throwable;
        }
    }
}

