/*
 * Decompiled with CFR 0.152.
 */
package me.decce.gnetum;

import java.util.HashMap;
import java.util.Map;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;

public class PackedVanillaElements {
    private static final Map<String, Pack> map;
    private static final Pack leftElements;
    private static final Pack rightElements;

    public static boolean isPacked(String element) {
        return map.containsKey(element);
    }

    public static Pack getPacked(String element) {
        return map.get(element);
    }

    public static Map<String, Pack> getMap() {
        return map;
    }

    static {
        leftElements = Pack.of("gnetum.packedElement.left", VanillaGuiLayers.ARMOR_LEVEL.toString(), VanillaGuiLayers.PLAYER_HEALTH.toString(), "appleskin:health_offset", "appleskin:health_restored", "farmersdelight:comfort", "farmersdelight:health_offset");
        rightElements = Pack.of("gnetum.packedElement.right", VanillaGuiLayers.AIR_LEVEL.toString(), VanillaGuiLayers.FOOD_LEVEL.toString(), VanillaGuiLayers.VEHICLE_HEALTH.toString(), "appleskin:exhaustion_level", "appleskin:food_offset", "appleskin:hunger_restored", "appleskin:saturation_level", "farmersdelight:food_offset", "farmersdelight:nourishment");
        map = new HashMap<String, Pack>(leftElements.getOverlays().length + rightElements.getOverlays().length);
        for (String overlay : leftElements.getOverlays()) {
            map.put(overlay, leftElements);
        }
        for (String overlay : rightElements.getOverlays()) {
            map.put(overlay, rightElements);
        }
    }

    public static class Pack {
        private String[] overlays;
        private String key;

        public static Pack of(String key, String ... overlays) {
            Pack pack = new Pack();
            pack.key = key;
            pack.overlays = overlays;
            return pack;
        }

        public String[] getOverlays() {
            return this.overlays;
        }

        public String getKey() {
            return this.key;
        }
    }
}

