/*
 * Decompiled with CFR 0.152.
 */
package me.decce.gnetum.gui;

import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import me.decce.gnetum.CacheSetting;
import me.decce.gnetum.Gnetum;
import me.decce.gnetum.gui.BaseScreen;
import me.decce.gnetum.gui.widgets.IntSlider;
import me.decce.gnetum.gui.widgets.ToggleButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.IModInfo;

public class ElementsScreen
extends BaseScreen {
    private Map<String, CacheSetting> map;
    private boolean vanilla;
    private int page;
    private int pageCount;
    private Button btnPrevPage;
    private Button btnNextPage;

    public ElementsScreen(Map<String, CacheSetting> map, boolean vanilla) {
        this.map = Maps.filterValues(map, c -> !c.hidden);
        this.vanilla = vanilla;
        this.pageCount = map.size() % 10 == 0 ? map.size() / 10 : map.size() / 10 + 1;
    }

    @Override
    public void init() {
        this.setPage(0);
    }

    @Override
    protected void rebuild() {
        super.rebuild();
        int max = Math.min(this.map.size(), this.page * 10 + 10);
        int wb = 130;
        int ws = 50;
        int extrawb = this.width - wb * 2 - ws * 2 - 60;
        extrawb = Math.max(0, Math.min(60, extrawb));
        int h = 20;
        int margin = 5;
        int xlb = this.width / 2 - 2 - ws - (wb += extrawb);
        int xls = this.width / 2 - 2 - ws;
        int xrb = this.width / 2 + 2;
        int xrs = this.width / 2 + 2 + wb;
        int y = this.height / 2 - h / 2 - margin - h - margin - h - 15;
        int i = 0;
        boolean left = true;
        for (Map.Entry<String, CacheSetting> entry : this.map.entrySet()) {
            if (i >= 10 * this.page && i < max) {
                ToggleButton btn2 = new ToggleButton(left ? xlb : xrb, y, wb, h, this.map.get((Object)entry.getKey()).enabled, () -> this.beautifyString((String)entry.getKey()) + ": %s");
                btn2.setTooltip(() -> {
                    String line1 = btn2.getMessage().getString() + "\n(" + (String)entry.getKey() + ")";
                    String line2 = I18n.get((String)("gnetum.config.tooltip." + ((CacheSetting)entry.getValue()).enabled.value.name().toLowerCase(Locale.ROOT)), (Object[])new Object[]{((CacheSetting)entry.getValue()).enabled.effectiveText()});
                    return line1 + "\n\n" + line2;
                });
                this.addRenderableWidget((GuiEventListener)btn2);
                IntSlider slider = new IntSlider(left ? xls : xrs, y, ws, h, () -> I18n.get((String)"gnetum.config.pass", (Object[])new Object[0]) + ": %s", 1, Gnetum.config.numberOfPasses, entry.getValue().pass, true, pass -> {
                    ((CacheSetting)entry.getValue()).pass = pass;
                });
                this.addRenderableWidget((GuiEventListener)slider);
                if (!left) {
                    y += h + margin;
                }
                left = !left;
            }
            ++i;
        }
        y = this.height / 2 + h / margin + h + margin + h + margin;
        Objects.requireNonNull(Minecraft.getInstance().font);
        int lineHeight = 9;
        int currentPage = this.map.isEmpty() ? 0 : this.page + 1;
        String pageString = currentPage + " / " + this.pageCount;
        int stringWidth = Minecraft.getInstance().font.width(pageString);
        StringWidget page = new StringWidget(this.width / 2 - stringWidth / 2, y + lineHeight / 2, stringWidth, lineHeight, (Component)Component.literal((String)pageString), Minecraft.getInstance().font);
        this.btnPrevPage = Button.builder((Component)Component.literal((String)"<"), btn -> this.setPage(this.page - 1)).pos(xlb, y).size(20, 20).build();
        this.btnNextPage = Button.builder((Component)Component.literal((String)">"), btn -> this.setPage(this.page + 1)).pos(xrs + ws - 20, y).size(20, 20).build();
        this.btnPrevPage.active = this.page > 0;
        this.btnNextPage.active = this.page < this.pageCount - 1;
        this.addRenderableWidget((GuiEventListener)page);
        this.addRenderableWidget((GuiEventListener)this.btnPrevPage);
        this.addRenderableWidget((GuiEventListener)this.btnNextPage);
    }

    private void setPage(int newPage) {
        this.page = newPage;
        this.rebuild();
    }

    @Override
    public void close() {
        super.close();
    }

    private String beautifyString(String string) {
        if (this.vanilla) {
            int i;
            Object key1 = string;
            if (!string.startsWith("gnetum.packedElement")) {
                key1 = "gnetum.config.element." + string.replace(':', '.');
            }
            if (I18n.exists((String)key1)) {
                return I18n.get((String)key1, (Object[])new Object[0]);
            }
            Object left = string.substring(0, string.indexOf(58));
            Object right = string.substring(string.indexOf(58) + 1);
            IModFileInfo file = ModList.get().getModFileById((String)left);
            left = file != null ? "[" + ((IModInfo)file.getMods().get(0)).getDisplayName() + "]" : "[" + (String)left + "]";
            right = Character.toUpperCase(((String)right).charAt(0)) + ((String)right).substring(1);
            while ((i = ((String)right).indexOf(95)) != -1) {
                right = ((String)right).substring(0, i) + " " + Character.toUpperCase(((String)right).charAt(i + 1)) + ((String)right).substring(i + 2);
            }
            return (String)left + " " + (String)right;
        }
        IModFileInfo file = ModList.get().getModFileById(string);
        return file == null ? string : ((IModInfo)file.getMods().get(0)).getDisplayName();
    }
}

