/*
 * Decompiled with CFR 0.152.
 */
package me.decce.gnetum;

import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexSorting;
import me.decce.gnetum.Gnetum;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.ForgeHooksClient;
import org.joml.Matrix4f;

public class FramebufferManager {
    private static final Minecraft mc = Minecraft.m_91087_();
    private static final FramebufferManager instance = new FramebufferManager();
    private boolean dropCurrentFrame;
    private boolean complete;
    private boolean toBeComplete = true;
    private int width;
    private int height;
    private double guiScale;
    private TextureTarget backFramebuffer;
    private TextureTarget frontFramebuffer;

    private FramebufferManager() {
        this.reset();
    }

    public static FramebufferManager getInstance() {
        return instance;
    }

    public void ensureSize() {
        if (mc.m_91268_().m_85441_() != this.width || mc.m_91268_().m_85442_() != this.height || mc.m_91268_().m_85449_() != this.guiScale) {
            this.reset();
        }
    }

    public void clear() {
        this.clear(this.backFramebuffer);
    }

    public void clear(TextureTarget framebuffer) {
        mc.m_91307_().m_6180_("clear");
        framebuffer.m_83954_(Minecraft.f_91002_);
        mc.m_91307_().m_7238_();
    }

    public void reset() {
        this.width = mc.m_91268_().m_85441_();
        this.height = mc.m_91268_().m_85442_();
        this.guiScale = mc.m_91268_().m_85449_();
        if (this.backFramebuffer != null && this.backFramebuffer.f_83920_ > 0) {
            this.backFramebuffer.m_83930_();
        }
        this.backFramebuffer = new TextureTarget(this.width, this.height, true, false);
        this.backFramebuffer.m_83931_(0.0f, 0.0f, 0.0f, 0.0f);
        this.backFramebuffer.m_83936_(9728);
        this.clear(this.backFramebuffer);
        if (this.frontFramebuffer != null && this.frontFramebuffer.f_83920_ > 0) {
            this.frontFramebuffer.m_83930_();
        }
        this.frontFramebuffer = new TextureTarget(this.width, this.height, true, false);
        this.frontFramebuffer.m_83931_(0.0f, 0.0f, 0.0f, 0.0f);
        this.frontFramebuffer.m_83936_(9728);
        this.clear(this.frontFramebuffer);
        this.markIncomplete();
        Gnetum.passManager.current = 1;
    }

    public void bind() {
        this.bind(true);
    }

    public void bind(boolean setViewport) {
        this.backFramebuffer.m_83947_(setViewport);
    }

    public void unbind() {
        mc.m_91385_().m_83947_(true);
    }

    public void blit() {
        mc.m_91307_().m_6180_("blit");
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)1, (int)771);
        this.frontFramebuffer.m_83957_(this.width, this.height, false);
        Window window = mc.m_91268_();
        Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, (float)((double)window.m_85441_() / window.m_85449_()), (float)((double)window.m_85442_() / window.m_85449_()), 0.0f, 1000.0f, ForgeHooksClient.getGuiFarPlane());
        RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (VertexSorting)VertexSorting.f_276633_);
        RenderSystem.defaultBlendFunc();
        mc.m_91307_().m_7238_();
    }

    public void swapFramebuffers() {
        if (!this.dropCurrentFrame) {
            TextureTarget temp = this.backFramebuffer;
            this.backFramebuffer = this.frontFramebuffer;
            this.frontFramebuffer = temp;
            if (this.toBeComplete) {
                this.complete = true;
            } else {
                this.toBeComplete = true;
            }
            Gnetum.FPS_COUNTER.tick();
        }
        this.clear();
        this.dropCurrentFrame = false;
    }

    public void dropCurrentFrame() {
        this.dropCurrentFrame = true;
    }

    public int id() {
        return this.backFramebuffer.f_83920_;
    }

    public void markIncomplete() {
        if (this.complete) {
            this.complete = false;
        } else {
            this.toBeComplete = false;
        }
    }

    public boolean isComplete() {
        return this.complete;
    }
}

