/*
 * Decompiled with CFR 0.152.
 */
package me.decce.gnetum.gui;

import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import me.decce.gnetum.CacheSetting;
import me.decce.gnetum.Gnetum;
import me.decce.gnetum.gui.BaseScreen;
import me.decce.gnetum.gui.widgets.IntSlider;
import me.decce.gnetum.gui.widgets.ToggleButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;

public class ElementsScreen
extends BaseScreen {
    private Map<String, CacheSetting> map;
    private boolean vanilla;
    private int page;
    private int pageCount;
    private Button btnPrevPage;
    private Button btnNextPage;

    public ElementsScreen(Map<String, CacheSetting> map, boolean vanilla) {
        this.map = Maps.filterValues(map, c -> !c.hidden);
        this.vanilla = vanilla;
        this.pageCount = this.map.size() % 10 == 0 ? this.map.size() / 10 : this.map.size() / 10 + 1;
    }

    @Override
    public void m_7856_() {
        this.setPage(0);
    }

    @Override
    protected void rebuild() {
        super.rebuild();
        int max = Math.min(this.map.size(), this.page * 10 + 10);
        int wb = 130;
        int ws = 50;
        int extrawb = this.f_96543_ - wb * 2 - ws * 2 - 60;
        extrawb = Math.max(0, Math.min(60, extrawb));
        int h = 20;
        int margin = 5;
        int xlb = this.f_96543_ / 2 - 2 - ws - (wb += extrawb);
        int xls = this.f_96543_ / 2 - 2 - ws;
        int xrb = this.f_96543_ / 2 + 2;
        int xrs = this.f_96543_ / 2 + 2 + wb;
        int y = this.f_96544_ / 2 - h / 2 - margin - h - margin - h - 15;
        int i = 0;
        boolean left = true;
        for (Map.Entry<String, CacheSetting> entry : this.map.entrySet()) {
            if (i >= 10 * this.page && i < max) {
                ToggleButton btn2 = new ToggleButton(left ? xlb : xrb, y, wb, h, this.map.get((Object)entry.getKey()).enabled, () -> this.beautifyString((String)entry.getKey()) + ": %s");
                btn2.setTooltip(() -> {
                    String line1 = btn2.m_6035_().getString() + "\n(" + (String)entry.getKey() + ")";
                    String line2 = I18n.m_118938_((String)("gnetum.config.tooltip." + ((CacheSetting)entry.getValue()).enabled.value.name().toLowerCase(Locale.ROOT)), (Object[])new Object[]{((CacheSetting)entry.getValue()).enabled.effectiveText()});
                    return line1 + "\n\n" + line2;
                });
                this.m_142416_((GuiEventListener)btn2);
                IntSlider slider = new IntSlider(left ? xls : xrs, y, ws, h, () -> I18n.m_118938_((String)"gnetum.config.pass", (Object[])new Object[0]) + ": %s", 1, Gnetum.config.numberOfPasses, entry.getValue().pass, true, pass -> {
                    ((CacheSetting)entry.getValue()).pass = pass;
                });
                this.m_142416_((GuiEventListener)slider);
                if (!left) {
                    y += h + margin;
                }
                left = !left;
            }
            ++i;
        }
        y = this.f_96544_ / 2 + h / margin + h + margin + h + margin;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        int lineHeight = 9;
        int currentPage = this.map.isEmpty() ? 0 : this.page + 1;
        String pageString = currentPage + " / " + this.pageCount;
        int stringWidth = Minecraft.m_91087_().f_91062_.m_92895_(pageString);
        StringWidget page = new StringWidget(this.f_96543_ / 2 - stringWidth / 2, y + lineHeight / 2, stringWidth, lineHeight, (Component)Component.m_237113_((String)pageString), Minecraft.m_91087_().f_91062_);
        this.btnPrevPage = Button.m_253074_((Component)Component.m_237113_((String)"<"), btn -> this.setPage(this.page - 1)).m_252794_(xlb, y).m_253046_(20, 20).m_253136_();
        this.btnNextPage = Button.m_253074_((Component)Component.m_237113_((String)">"), btn -> this.setPage(this.page + 1)).m_252794_(xrs + ws - 20, y).m_253046_(20, 20).m_253136_();
        this.btnPrevPage.f_93623_ = this.page > 0;
        this.btnNextPage.f_93623_ = this.page < this.pageCount - 1;
        this.m_142416_((GuiEventListener)page);
        this.m_142416_((GuiEventListener)this.btnPrevPage);
        this.m_142416_((GuiEventListener)this.btnNextPage);
    }

    private void setPage(int newPage) {
        this.page = newPage;
        this.rebuild();
    }

    @Override
    public void close() {
        super.close();
    }

    private String beautifyString(String string) {
        if (this.vanilla) {
            int i;
            Object key1 = string;
            if (!string.startsWith("gnetum.packedElement")) {
                key1 = "gnetum.config.element." + string.replace(':', '.');
            }
            if (I18n.m_118936_((String)key1)) {
                return I18n.m_118938_((String)key1, (Object[])new Object[0]);
            }
            Object left = string.substring(0, string.indexOf(58));
            Object right = string.substring(string.indexOf(58) + 1);
            IModFileInfo file = ModList.get().getModFileById((String)left);
            left = file != null ? "[" + ((IModInfo)file.getMods().get(0)).getDisplayName() + "]" : "[" + (String)left + "]";
            right = Character.toUpperCase(((String)right).charAt(0)) + ((String)right).substring(1);
            while ((i = ((String)right).indexOf(95)) != -1) {
                right = ((String)right).substring(0, i) + " " + Character.toUpperCase(((String)right).charAt(i + 1)) + ((String)right).substring(i + 2);
            }
            return (String)left + " " + (String)right;
        }
        if ("gnetum_unknown".equals(string)) {
            return I18n.m_118938_((String)"gnetum.config.element.gnetum_unknown", (Object[])new Object[0]);
        }
        IModFileInfo file = ModList.get().getModFileById(string);
        return file == null ? string : ((IModInfo)file.getMods().get(0)).getDisplayName();
    }
}

