/*
 * Decompiled with CFR 0.152.
 */
package me.decce.gnetum;

import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.io.File;
import java.net.URL;
import java.security.CodeSource;
import java.util.List;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.ASMEventHandler;

public class ASMEventHandlerHelper {
    private static final ReferenceSet<ASMEventHandler> invalid = new ReferenceOpenHashSet(0);
    private static final Reference2ObjectMap<ASMEventHandler, String> mapModId = new Reference2ObjectOpenHashMap();

    public static String tryGetModId(ASMEventHandler asm) {
        if (mapModId.containsKey((Object)asm)) {
            return (String)mapModId.get((Object)asm);
        }
        if (invalid.contains((Object)asm)) {
            return null;
        }
        Class<?> clazz = ASMEventHandlerHelper.tryGetClass(asm);
        if (clazz == null) {
            invalid.add((Object)asm);
            return null;
        }
        CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
        if (codeSource == null) {
            invalid.add((Object)asm);
            return null;
        }
        URL url = codeSource.getLocation();
        List mods = Loader.instance().getActiveModList();
        for (int i = 0; i < mods.size(); ++i) {
            ModContainer mod = (ModContainer)mods.get(i);
            File file = mod.getSource();
            if (!url.getPath().contains(file.getAbsolutePath()) && !url.getPath().contains(file.getPath())) continue;
            String modid = mod.getModId();
            mapModId.put((Object)asm, (Object)modid);
            return modid;
        }
        invalid.add((Object)asm);
        return null;
    }

    private static Class<?> tryGetClass(ASMEventHandler asm) {
        String name = asm.toString().substring(5);
        if (name.startsWith("class ")) {
            name = name.substring(6);
            name = name.substring(0, name.indexOf(32));
            try {
                Class<?> clazz = Class.forName(name);
                return clazz;
            }
            catch (Throwable ignored) {
                return null;
            }
        }
        if (name.contains("@")) {
            name = name.substring(0, name.indexOf(64));
            try {
                Class<?> clazz = Class.forName(name);
                return clazz;
            }
            catch (Throwable ignored) {
                return null;
            }
        }
        return null;
    }
}

