/*
 * Decompiled with CFR 0.152.
 */
package me.decce.gnetum;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Properties;
import me.decce.gnetum.CacheSetting;
import me.decce.gnetum.ElementType;
import me.decce.gnetum.Gnetum;
import me.decce.gnetum.PerformanceAnalyzer;
import me.decce.gnetum.util.AnyBooleanValue;
import me.decce.gnetum.util.TriStateBoolean;
import me.decce.gnetum.util.TwoStateBoolean;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.io.FileUtils;

public class GnetumConfig {
    public static final int UNLIMITED_FPS = 125;
    private static Path path;
    private static Path pathOld;
    public TwoStateBoolean enabled = new TwoStateBoolean(AnyBooleanValue.ON);
    public TwoStateBoolean showHudFps = new TwoStateBoolean(AnyBooleanValue.ON);
    public int numberOfPasses = 3;
    public int maxFps = 60;
    public HashMap<String, CacheSetting> mapVanillaElements = new HashMap();
    public HashMap<String, CacheSetting> mapModdedElementsPre = new HashMap();
    public HashMap<String, CacheSetting> mapModdedElementsPost = new HashMap();

    public boolean isEnabled() {
        return this.enabled.get();
    }

    private static void importOld(GnetumConfig config) {
        if (Files.exists(pathOld, new LinkOption[0])) {
            try {
                Properties prop = new Properties();
                try (FileInputStream fis = new FileInputStream(pathOld.toFile());){
                    prop.load(fis);
                    config.enabled.value = "true".equals(prop.getProperty("enabled")) ? AnyBooleanValue.ON : AnyBooleanValue.OFF;
                    config.mapVanillaElements.get((Object)"gnetum:minecraft_hand").enabled.value = "true".equals(prop.getProperty("bufferHand")) ? AnyBooleanValue.ON : AnyBooleanValue.AUTO;
                }
                Files.delete(pathOld);
                config.save();
                Gnetum.LOGGER.info("Successfully imported configuration from file \"Gnetum.cfg\"!");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static GnetumConfig createDefault() {
        GnetumConfig config = new GnetumConfig();
        config.mapVanillaElements.put("gnetum:minecraft_hand", new CacheSetting(1, new TriStateBoolean(AnyBooleanValue.AUTO, false)));
        GnetumConfig.importOld(config);
        return config;
    }

    public static GnetumConfig load(Path path) {
        GnetumConfig.path = path.resolve("gnetum.json");
        pathOld = path.resolve("Gnetum.cfg");
        try {
            if (!Files.exists(GnetumConfig.path, new LinkOption[0])) {
                return GnetumConfig.createDefault();
            }
            String json = FileUtils.readFileToString((File)GnetumConfig.path.toFile(), (Charset)StandardCharsets.UTF_8);
            Gson gson = new Gson();
            GnetumConfig config = (GnetumConfig)gson.fromJson(json, GnetumConfig.class);
            if (!config.mapVanillaElements.containsKey("gnetum:minecraft_hand")) {
                config.mapVanillaElements.put("gnetum:minecraft_hand", new CacheSetting(1, new TriStateBoolean(AnyBooleanValue.AUTO, false)));
            }
            config.mapVanillaElements.get((Object)"gnetum:minecraft_hand").enabled.defaultValue = false;
            config.validate();
            return config;
        }
        catch (IOException e) {
            Gnetum.LOGGER.error("Failed to read configuration!", (Throwable)e);
            return GnetumConfig.createDefault();
        }
    }

    public void validate() {
        this.numberOfPasses = GnetumConfig.clamp(this.numberOfPasses, 2, 10);
        this.mapVanillaElements.forEach((s, c) -> {
            c.pass = GnetumConfig.clamp(c.pass, 1, this.numberOfPasses);
        });
        this.mapModdedElementsPre.forEach((s, c) -> {
            c.pass = GnetumConfig.clamp(c.pass, 1, this.numberOfPasses);
        });
        this.mapModdedElementsPost.forEach((s, c) -> {
            c.pass = GnetumConfig.clamp(c.pass, 1, this.numberOfPasses);
        });
        this.maxFps = GnetumConfig.clamp(this.maxFps, 1, 125);
        this.hideElementsOrphanOrUncached();
    }

    private void hideElementsOrphanOrUncached() {
        this.mapModdedElementsPre.entrySet().stream().filter(entry -> !Loader.isModLoaded((String)((String)entry.getKey())) || Gnetum.uncachedElements.has((String)entry.getKey(), ElementType.PRE)).forEach(entry -> {
            ((CacheSetting)entry.getValue()).hidden = true;
        });
        this.mapModdedElementsPost.entrySet().stream().filter(entry -> !Loader.isModLoaded((String)((String)entry.getKey())) || Gnetum.uncachedElements.has((String)entry.getKey(), ElementType.POST)).forEach(entry -> {
            ((CacheSetting)entry.getValue()).hidden = true;
        });
        this.mapVanillaElements.forEach((s, c) -> {
            int semicolon = s.indexOf(58);
            if (semicolon == -1) {
                return;
            }
            String modid = s.substring(0, semicolon);
            if (!Loader.isModLoaded((String)modid) || Gnetum.uncachedElements.has((String)s)) {
                c.hidden = true;
            }
        });
    }

    private static int clamp(int value, int min, int max) {
        return Math.max(Math.min(value, max), min);
    }

    public static void reload() {
        Gnetum.config = GnetumConfig.load(path);
    }

    public static void reset() {
        Gnetum.config = GnetumConfig.createDefault();
        Gnetum.config.save();
    }

    public void save() {
        this.validate();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson((Object)this);
        try {
            FileUtils.writeStringToFile((File)path.toFile(), (String)json, (Charset)StandardCharsets.UTF_8, (boolean)false);
        }
        catch (IOException e) {
            Gnetum.LOGGER.error("Failed to save config file!", (Throwable)e);
        }
        if (PerformanceAnalyzer.latestAnalysisResult != null) {
            PerformanceAnalyzer.latestAnalysisResult.markOutdated();
        }
    }
}

