/*
 * Decompiled with CFR 0.152.
 */
package me.decce.gnetum.compat.betterhud;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Comparator;
import jobicade.betterhud.BetterHud;
import jobicade.betterhud.element.HudElement;
import jobicade.betterhud.events.RenderEvents;
import me.decce.gnetum.CacheSetting;
import me.decce.gnetum.Gnetum;
import me.decce.gnetum.hud.Hud;
import me.decce.gnetum.hud.VanillaHuds;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BetterHudCompat {
    public static final String MODID = "betterhud";
    public static final boolean modInstalled;
    public static final Hud OTHER_HUD;
    public static Reference2ReferenceMap<HudElement, Hud> mapTranslation;

    public static boolean isEnabled() {
        return modInstalled && BetterHud.getProxy().isModEnabled();
    }

    public static void onRenderGameOverlays(RenderGameOverlayEvent.Pre event) {
        BetterHud.MANAGER.reset(event.getResolution());
        RenderEvents.beginOverlayState();
        int pass = Gnetum.rendering ? Gnetum.passManager.current : 0;
        for (HudElement element : HudElement.SORTER.getSortedData((Comparator)HudElement.SortType.PRIORITY)) {
            if (BetterHudCompat.passOf(element) != pass) continue;
            element.tryRender((Event)event);
        }
        RenderEvents.endOverlayState();
        GlStateManager.func_179147_l();
    }

    public static int passOf(HudElement element) {
        if (mapTranslation.containsKey((Object)element)) {
            return BetterHudCompat.passOf((Hud)mapTranslation.get((Object)element));
        }
        return BetterHudCompat.passOf(OTHER_HUD);
    }

    public static int passOf(Hud hud) {
        CacheSetting cache = Gnetum.getCacheSetting(hud.id().toString());
        return cache.enabled.get() ? cache.pass : 0;
    }

    static {
        OTHER_HUD = Hud.builder().id(MODID, "other_huds").build();
        mapTranslation = new Reference2ReferenceOpenHashMap();
        modInstalled = Loader.isModLoaded((String)MODID);
        if (modInstalled) {
            mapTranslation.put((Object)HudElement.HEALTH, (Object)VanillaHuds.PLAYER_LEFT);
            mapTranslation.put((Object)HudElement.ARMOR_BAR, (Object)VanillaHuds.PLAYER_LEFT);
            mapTranslation.put((Object)HudElement.AIR_BAR, (Object)VanillaHuds.PLAYER_RIGHT);
            mapTranslation.put((Object)HudElement.FOOD_BAR, (Object)VanillaHuds.PLAYER_RIGHT);
            mapTranslation.put((Object)HudElement.MOUNT, (Object)VanillaHuds.PLAYER_RIGHT);
            mapTranslation.put((Object)HudElement.CROSSHAIR, (Object)VanillaHuds.CROSSHAIRS);
            mapTranslation.put((Object)HudElement.VIGNETTE, (Object)VanillaHuds.VIGNETTE);
            mapTranslation.put((Object)HudElement.EXPERIENCE, (Object)VanillaHuds.EXPERIENCE);
            mapTranslation.put((Object)HudElement.EXPERIENCE_INFO, (Object)VanillaHuds.EXPERIENCE);
            mapTranslation.put((Object)HudElement.HELMET_OVERLAY, (Object)VanillaHuds.HELMET);
            mapTranslation.put((Object)HudElement.HOTBAR, (Object)VanillaHuds.HOTBAR);
            mapTranslation.put((Object)HudElement.JUMP_BAR, (Object)VanillaHuds.JUMP_BAR);
            mapTranslation.put((Object)HudElement.PORTAL, (Object)VanillaHuds.PORTAL);
            mapTranslation.put((Object)HudElement.POTION_BAR, (Object)VanillaHuds.POTION_ICONS);
            mapTranslation.put((Object)HudElement.SIDEBAR, (Object)VanillaHuds.SCOREBOARD);
        }
    }
}

