/*
 * Decompiled with CFR 0.152.
 */
package me.decce.gnetum.gui;

import me.decce.gnetum.PerformanceAnalyzer;
import me.decce.gnetum.gui.BaseScreen;
import me.decce.gnetum.gui.widgets.MultilineStringWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public class AnalysisScreen
extends BaseScreen {
    public final PerformanceAnalyzer.Result analysis;
    private MultilineStringWidget txt;

    public AnalysisScreen(PerformanceAnalyzer.Result analysis) {
        this.analysis = analysis;
    }

    @Override
    public void close() {
        Minecraft.func_71410_x().func_147108_a(this.parent);
    }

    @Override
    protected void rebuild() {
        super.rebuild();
        String body = this.analysis.getMessages().isEmpty() ? I18n.func_135052_a((String)"gnetum.config.analysis.good", (Object[])new Object[0]) : String.join((CharSequence)"\n\n", this.analysis.getMessages());
        StringBuilder data = new StringBuilder();
        long[] durations = this.analysis.getDurations();
        if (durations == null) {
            data.append(I18n.func_135052_a((String)"gnetum.config.analysis.failedDuration", (Object[])new Object[0]));
        } else {
            data.append(I18n.func_135052_a((String)"gnetum.config.analysis.detailDuration", (Object[])new Object[0]));
            for (int i = 1; i < durations.length; ++i) {
                data.append("\n");
                data.append("Pass [").append(i).append("] - ").append(String.format("%.2f", (double)durations[i] / 1000.0)).append("\u03bcs");
            }
        }
        String str = body + "\n\n" + data.toString();
        int w = 300;
        int h = 150;
        this.txt = new MultilineStringWidget(11, this.field_146294_l / 2 - w / 2, this.field_146295_m / 2 - h / 2, w, str);
        this.func_189646_b(this.txt);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        String title = I18n.func_135052_a((String)(this.analysis.getIcon() == PerformanceAnalyzer.ResultIcon.TICK ? "gnetum.config.analysis.title.good" : "gnetum.config.analysis.title.suboptimal"), (Object[])new Object[0]);
        int titleWidth = this.field_146289_q.func_78256_a(title);
        int xfont = this.field_146294_l / 2 - titleWidth / 2 + 8 + 2;
        int xicon = xfont - 4 - 16;
        int y = this.field_146295_m / 2 - 90;
        ResourceLocation icon = this.analysis.getIcon().icon();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(icon);
        super.func_73729_b(xicon, y - 8, 0, 0, 16, 16);
        super.func_73731_b(this.field_146289_q, title, xfont, y, 0xFFFFFF);
    }
}

