/*
 * Decompiled with CFR 0.152.
 */
package me.decce.gnetum.gui;

import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;
import me.decce.gnetum.CacheSetting;
import me.decce.gnetum.Gnetum;
import me.decce.gnetum.ModListHelper;
import me.decce.gnetum.gui.BaseScreen;
import me.decce.gnetum.gui.widgets.GuiButtonEx;
import me.decce.gnetum.gui.widgets.IntSlider;
import me.decce.gnetum.gui.widgets.MultilineStringWidget;
import me.decce.gnetum.gui.widgets.StringWidget;
import me.decce.gnetum.gui.widgets.ToggleButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;

public class ElementsScreen
extends BaseScreen {
    public static final int BTN_PREV_PAGE = 1;
    public static final int BTN_NEXT_PAGE = 2;
    public static final int TXT_PAGE = 3;
    public static final int TXT_NOTICE = 4;
    private Map<String, CacheSetting> map;
    private boolean vanilla;
    private int page;
    private int pageCount;
    private GuiButtonEx btnPrevPage;
    private GuiButtonEx btnNextPage;

    public ElementsScreen(Map<String, CacheSetting> map, boolean vanilla) {
        this.map = Maps.filterValues(map, c -> !c.hidden);
        this.vanilla = vanilla;
        this.pageCount = this.map.size() % 10 == 0 ? this.map.size() / 10 : this.map.size() / 10 + 1;
    }

    @Override
    public void func_73866_w_() {
        this.setPage(0);
    }

    @Override
    protected void rebuild() {
        super.rebuild();
        int max = Math.min(this.map.size(), this.page * 10 + 10);
        int wb = 130;
        int ws = 50;
        int extrawb = this.field_146294_l - wb * 2 - ws * 2 - 60;
        extrawb = Math.max(0, Math.min(60, extrawb));
        int h = 20;
        int margin = 5;
        int xlb = this.field_146294_l / 2 - 2 - ws - (wb += extrawb);
        int xls = this.field_146294_l / 2 - 2 - ws;
        int xrb = this.field_146294_l / 2 + 2;
        int xrs = this.field_146294_l / 2 + 2 + wb;
        int y = this.field_146295_m / 2 - h / 2 - margin - h - margin - h - 12;
        int i = 0;
        String noticeString = this.vanilla ? "" : I18n.func_135052_a((String)"gnetum.config.element.notice", (Object[])new Object[0]);
        MultilineStringWidget notice = new MultilineStringWidget(4, xlb, y - 28, 2 * (wb + ws) + margin, noticeString);
        boolean left = true;
        int id = 11;
        for (Map.Entry<String, CacheSetting> entry : this.map.entrySet()) {
            if (i >= 10 * this.page && i < max) {
                ToggleButton btn = new ToggleButton(id++, left ? xlb : xrb, y, wb, h, this.map.get((Object)entry.getKey()).enabled, () -> this.beautifyString((String)entry.getKey()) + ": %s");
                btn.setTooltip(() -> {
                    String line1 = btn.field_146126_j + "\n(" + (String)entry.getKey() + ")";
                    String line2 = I18n.func_135052_a((String)("gnetum.config.tooltip." + ((CacheSetting)entry.getValue()).enabled.value.name().toLowerCase(Locale.ROOT)), (Object[])new Object[]{((CacheSetting)entry.getValue()).enabled.effectiveText()});
                    return line1 + "\n\n" + line2;
                });
                this.func_189646_b((GuiButton)btn);
                IntSlider slider = new IntSlider(id++, left ? xls : xrs, y, ws, h, () -> I18n.func_135052_a((String)"gnetum.config.pass", (Object[])new Object[0]) + ": %s", 1, Gnetum.config.numberOfPasses, entry.getValue().pass, true, pass -> {
                    ((CacheSetting)entry.getValue()).pass = pass;
                });
                this.func_189646_b((GuiButton)slider);
                if (!left) {
                    y += h + margin;
                }
                left = !left;
            }
            ++i;
        }
        y = this.field_146295_m / 2 + h / margin + h + margin + h + margin;
        int lineHeight = Minecraft.func_71410_x().field_71466_p.field_78288_b;
        int currentPage = this.map.isEmpty() ? 0 : this.page + 1;
        String pageString = currentPage + " / " + this.pageCount;
        StringWidget page = new StringWidget(3, this.field_146294_l / 2, y + lineHeight / 2, pageString);
        this.btnPrevPage = new GuiButtonEx(1, xlb, y, 20, 20, "<", () -> this.setPage(this.page - 1));
        this.btnNextPage = new GuiButtonEx(2, xrs + ws - 20, y, 20, 20, ">", () -> this.setPage(this.page + 1));
        this.btnPrevPage.field_146124_l = this.page > 0;
        this.btnNextPage.field_146124_l = this.page < this.pageCount - 1;
        this.func_189646_b(notice);
        this.func_189646_b(page);
        this.func_189646_b((GuiButton)this.btnPrevPage);
        this.func_189646_b((GuiButton)this.btnNextPage);
    }

    private void setPage(int newPage) {
        this.page = newPage;
        this.rebuild();
    }

    @Override
    public void close() {
        super.close();
    }

    private String beautifyString(String string) {
        if (this.vanilla) {
            int i;
            String key1 = string;
            if (!string.startsWith("gnetum.packedElement")) {
                key1 = "gnetum.config.element." + string.replace(':', '.');
            }
            if (I18n.func_188566_a((String)key1)) {
                return I18n.func_135052_a((String)key1, (Object[])new Object[0]);
            }
            String left = string.substring(0, string.indexOf(58));
            String right = string.substring(string.indexOf(58) + 1);
            String name = ModListHelper.getModName(left);
            left = name != null ? "[" + name + "]" : "[" + left + "]";
            right = Character.toUpperCase(right.charAt(0)) + right.substring(1);
            while ((i = right.indexOf(95)) != -1) {
                right = right.substring(0, i) + " " + Character.toUpperCase(right.charAt(i + 1)) + right.substring(i + 2);
            }
            return left + " " + right;
        }
        String name = ModListHelper.getModName(string);
        return name == null ? string : name;
    }
}

