/*
 * Decompiled with CFR 0.152.
 */
package me.decce.gnetum.gui.widgets;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import me.decce.gnetum.gui.widgets.ITooltipWidget;
import me.decce.gnetum.gui.widgets.TooltipHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraftforge.fml.client.config.GuiSlider;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.client.config.HoverChecker;

public class IntSlider
extends GuiSlider
implements ITooltipWidget {
    private final HoverChecker hoverChecker = new HoverChecker((GuiButton)this, 0);
    private List<String> tooltip = Collections.emptyList();
    private final Supplier<String> text;
    private final Supplier<String> specialText;
    private final Consumer<Integer> setter;
    private final Predicate<Integer> special;
    private final int step;

    public IntSlider(int id, int x, int y, int width, int height, Supplier<String> text, int minValue, int maxValue, int currentValue, boolean drawString, Consumer<Integer> setter) {
        this(id, x, y, width, height, text, minValue, maxValue, currentValue, 1, drawString, setter);
    }

    public IntSlider(int id, int x, int y, int width, int height, Supplier<String> text, int minValue, int maxValue, int currentValue, int step, boolean drawString, Consumer<Integer> setter) {
        this(id, x, y, width, height, text, minValue, maxValue, currentValue, step, drawString, setter, null, null);
    }

    public IntSlider(int id, int x, int y, int width, int height, Supplier<String> text, int minValue, int maxValue, int currentValue, int step, boolean drawString, Consumer<Integer> setter, Predicate<Integer> special, Supplier<String> specialText) {
        super(id, x, y, width, height, "", "", (double)minValue, (double)maxValue, (double)currentValue, false, drawString);
        this.step = step;
        this.setter = setter;
        this.text = text;
        this.special = special;
        this.specialText = specialText;
        this.showDecimal = false;
        this.updateSlider();
    }

    public void setTooltip(String tooltip) {
        this.tooltip = TooltipHelper.createTooltip(tooltip);
    }

    public void updateSlider() {
        super.updateSlider();
        if (this.special == null || !this.special.test(this.getValueInt())) {
            if (this.text != null) {
                this.field_146126_j = String.format(this.text.get(), this.getValueInt());
            }
        } else {
            this.field_146126_j = String.format(this.specialText.get(), this.getValueInt());
        }
        this.setter.accept(this.getValueInt());
    }

    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partial) {
        super.func_191745_a(mc, mouseX, mouseY, partial);
    }

    public int getValueInt() {
        return this.step * Math.round((float)super.getValueInt() * 1.0f / (float)this.step);
    }

    @Override
    public void drawTooltip(int mouseX, int mouseY) {
        GuiScreen screen;
        if (this.hoverChecker.checkHover(mouseX, mouseY) && (screen = Minecraft.func_71410_x().field_71462_r) != null) {
            GuiUtils.drawHoveringText(this.tooltip, (int)mouseX, (int)mouseY, (int)screen.field_146294_l, (int)screen.field_146295_m, (int)400, (FontRenderer)Minecraft.func_71410_x().field_71466_p);
            RenderHelper.func_74518_a();
        }
    }
}

