/*
 * Decompiled with CFR 0.152.
 */
package me.decce.gnetum;

import java.nio.FloatBuffer;
import me.decce.gnetum.Gnetum;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.Framebuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GLContext;

public class FramebufferManager {
    public static final boolean GL30SUPPORT = GLContext.getCapabilities().OpenGL30;
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final FramebufferManager instance = new FramebufferManager();
    private int width;
    private int height;
    private int guiScale;
    private boolean fullscreen;
    private boolean dropCurrentFrame;
    private boolean complete;
    private final FloatBuffer clearColor;
    private Framebuffer backFramebuffer;
    private Framebuffer frontFramebuffer;

    private FramebufferManager() {
        this.width = FramebufferManager.mc.field_71443_c;
        this.height = FramebufferManager.mc.field_71440_d;
        this.guiScale = FramebufferManager.mc.field_71474_y.field_74335_Z;
        this.fullscreen = FramebufferManager.mc.field_71474_y.field_74353_u;
        this.clearColor = GLAllocation.func_74529_h((int)4);
        this.clearColor.put(0.0f).put(0.0f).put(0.0f).put(0.0f);
        this.clearColor.flip();
        this.reset();
    }

    public static FramebufferManager getInstance() {
        return instance;
    }

    public void reset() {
        if (this.backFramebuffer != null) {
            this.backFramebuffer.func_147608_a();
        }
        if (this.frontFramebuffer != null) {
            this.frontFramebuffer.func_147608_a();
        }
        this.backFramebuffer = new Framebuffer(this.width, this.height, true);
        this.backFramebuffer.func_147604_a(0.0f, 0.0f, 0.0f, 0.0f);
        this.backFramebuffer.func_147607_a(9728);
        this.backFramebuffer.func_147610_a(false);
        this.clear();
        this.unbind();
        this.frontFramebuffer = new Framebuffer(this.width, this.height, true);
        this.frontFramebuffer.func_147604_a(0.0f, 0.0f, 0.0f, 0.0f);
        this.frontFramebuffer.func_147607_a(9728);
        this.frontFramebuffer.func_147610_a(false);
        this.clear();
        this.unbind();
        this.complete = false;
        Gnetum.passManager.current = 1;
    }

    public void ensureSize() {
        if (FramebufferManager.mc.field_71443_c != this.width || FramebufferManager.mc.field_71440_d != this.height || FramebufferManager.mc.field_71474_y.field_74335_Z != this.guiScale || FramebufferManager.mc.field_71474_y.field_74353_u != this.fullscreen) {
            this.width = FramebufferManager.mc.field_71443_c;
            this.height = FramebufferManager.mc.field_71440_d;
            this.guiScale = FramebufferManager.mc.field_71474_y.field_74335_Z;
            this.fullscreen = FramebufferManager.mc.field_71474_y.field_74353_u;
            this.reset();
        }
    }

    private void clear() {
        this.clear(this.backFramebuffer.field_147616_f);
    }

    private void clear(int fbo) {
        OpenGlHelper.func_153171_g((int)36160, (int)fbo);
        GlStateManager.func_179151_a((double)1.0);
        if (GL30SUPPORT) {
            GL30.glClearBuffer((int)6144, (int)0, (FloatBuffer)this.clearColor);
            GlStateManager.func_179086_m((int)256);
        } else {
            GlStateManager.func_179082_a((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179086_m((int)16640);
        }
    }

    public void bind() {
        this.bind(false);
    }

    public void bind(boolean setViewport) {
        this.backFramebuffer.func_147610_a(setViewport);
    }

    public void unbind() {
        mc.func_147110_a().func_147610_a(false);
    }

    public void blit(double width, double height) {
        FramebufferManager.mc.field_71424_I.func_76320_a("blit");
        this.frontFramebuffer.func_147612_c();
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)1, (int)771, (int)1, (int)771);
        GlStateManager.func_179097_i();
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        builder.func_181662_b(0.0, height, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        builder.func_181662_b(width, height, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        builder.func_181662_b(width, 0.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        builder.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179126_j();
        GlStateManager.func_179084_k();
        FramebufferManager.mc.field_71424_I.func_76319_b();
    }

    public void swapFramebuffers() {
        if (!this.dropCurrentFrame) {
            Framebuffer temp = this.backFramebuffer;
            this.backFramebuffer = this.frontFramebuffer;
            this.frontFramebuffer = temp;
            this.complete = true;
            Gnetum.FPS_COUNTER.tick();
        }
        this.clear();
        this.dropCurrentFrame = false;
    }

    public void dropCurrentFrame() {
        this.dropCurrentFrame = true;
    }

    public int id() {
        return this.backFramebuffer.field_147616_f;
    }

    public boolean isComplete() {
        return this.complete;
    }
}

