/*
 * Decompiled with CFR 0.152.
 */
package me.decce.gnetum;

import java.util.HashMap;
import me.decce.gnetum.CacheSetting;
import me.decce.gnetum.ElementType;
import me.decce.gnetum.FpsCounter;
import me.decce.gnetum.FramebufferManager;
import me.decce.gnetum.GnetumConfig;
import me.decce.gnetum.MutableScaledResolution;
import me.decce.gnetum.PassManager;
import me.decce.gnetum.PerformanceAnalyzer;
import me.decce.gnetum.SuggestedPass;
import me.decce.gnetum.UncachedElements;
import me.decce.gnetum.gui.BaseScreen;
import me.decce.gnetum.gui.ConfigScreen;
import me.decce.gnetum.hud.VanillaHuds;
import me.decce.gnetum.util.AnyBooleanValue;
import me.decce.gnetum.util.time.GlfwTimeSource;
import me.decce.gnetum.util.time.JavaTimeSource;
import me.decce.gnetum.util.time.TimeSource;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="gnetum")
@Mod(modid="gnetum", name="Gnetum", version="1.3.2", clientSideOnly=true, acceptableRemoteVersions="*", guiFactory="me.decce.gnetum.GnetumConfigGuiFactory")
public class Gnetum {
    private static MutableScaledResolution scaledResolution;
    private static TimeSource timeSource;
    public static final FpsCounter FPS_COUNTER;
    public static GnetumConfig config;
    public static final String HAND_ELEMENT = "gnetum:minecraft_hand";
    public static final String OTHER_MODS = "gnetum_unknown";
    public static PassManager passManager;
    public static UncachedElements uncachedElements;
    public static String currentElement;
    public static ElementType currentElementType;
    public static boolean rendering;
    public static boolean renderingCanceled;
    public static boolean isRenderingHelmet;
    public static long lastSwapNanos;
    public static final KeyBinding KEYBIND;
    public static Logger LOGGER;

    public static MutableScaledResolution getScaledResolution() {
        if (scaledResolution == null) {
            scaledResolution = new MutableScaledResolution();
        }
        return scaledResolution;
    }

    public static TimeSource getTimeSource() {
        if (timeSource == null) {
            timeSource = GlfwTimeSource.isAvailable() ? new GlfwTimeSource() : new JavaTimeSource();
        }
        return timeSource;
    }

    public static CacheSetting getCacheSetting(String vanillaOverlay) {
        if (!Gnetum.config.mapVanillaElements.containsKey(vanillaOverlay)) {
            Gnetum.config.mapVanillaElements.put(vanillaOverlay, new CacheSetting(SuggestedPass.get(vanillaOverlay)));
        }
        return Gnetum.config.mapVanillaElements.get(vanillaOverlay);
    }

    public static CacheSetting getCacheSetting(String moddedOverlay, ElementType type) {
        HashMap<String, CacheSetting> map;
        if (type == ElementType.VANILLA) {
            return Gnetum.getCacheSetting(moddedOverlay);
        }
        HashMap<String, CacheSetting> hashMap = map = type == ElementType.PRE ? Gnetum.config.mapModdedElementsPre : Gnetum.config.mapModdedElementsPost;
        if (!map.containsKey(moddedOverlay)) {
            map.put(moddedOverlay, new CacheSetting(type == ElementType.PRE ? 1 : Gnetum.config.numberOfPasses));
            config.validate();
        }
        return map.get(moddedOverlay);
    }

    public static void disableCachingForCurrentElement() {
        if (currentElement == null || currentElementType == null) {
            return;
        }
        CacheSetting cacheSetting = Gnetum.getCacheSetting(currentElement, currentElementType);
        if (cacheSetting.enabled.get() && cacheSetting.enabled.value == AnyBooleanValue.AUTO) {
            LOGGER.info("Disabling caching for element {}. If the cache setting for this element is set to \"ON\" instead of \"AUTO\" you can ignore this message.", (Object)currentElement);
            cacheSetting.enabled.defaultValue = false;
            FramebufferManager.getInstance().dropCurrentFrame();
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LOGGER = event.getModLog();
        uncachedElements = new UncachedElements();
        config = GnetumConfig.load(event.getModConfigurationDirectory().toPath());
        passManager = new PassManager();
        VanillaHuds.init();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ClientRegistry.registerKeyBinding((KeyBinding)KEYBIND);
    }

    @SubscribeEvent
    public static void onJoinWorld(WorldEvent.Load event) {
        if (config.isEnabled() && event.getWorld().field_72995_K) {
            FPS_COUNTER.reset();
            FramebufferManager.getInstance().reset();
        }
    }

    @SubscribeEvent
    public static void onKeyPressed(InputEvent.KeyInputEvent event) {
        if (KEYBIND.func_151468_f() && !(Minecraft.func_71410_x().field_71462_r instanceof BaseScreen)) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new ConfigScreen(PerformanceAnalyzer.analyze()));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onRenderF3(RenderGameOverlayEvent.Text event) {
        if (!config.isEnabled() || !Gnetum.config.showHudFps.get()) {
            return;
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            String str = String.format("HUD: %d fps (nr=%d, cap=%s)", FPS_COUNTER.getFps(), Gnetum.config.numberOfPasses, Gnetum.config.maxFps == 125 ? "unlimited" : Integer.valueOf(Gnetum.config.maxFps));
            if (event.getLeft().size() > 2) {
                event.getLeft().add(2, str);
            } else {
                event.getLeft().add(str);
            }
        }
    }

    static {
        FPS_COUNTER = new FpsCounter();
        KEYBIND = new KeyBinding("gnetum.config.keyMapping", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, 207, "key.categories.misc");
    }
}

