/*
 * Decompiled with CFR 0.152.
 */
package me.decce.gnetum;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.decce.gnetum.CacheSetting;
import me.decce.gnetum.Gnetum;
import me.decce.gnetum.Icons;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public class PerformanceAnalyzer {
    private static final double DURATION_TOO_LONG_CRITERIA = 1.6;
    public static Result latestAnalysisResult;

    public static Result analyze() {
        Result result = new Result();
        PerformanceAnalyzer.analyzePass(result);
        PerformanceAnalyzer.analyzeDurations(result);
        latestAnalysisResult = result;
        return result;
    }

    private static void analyzePass(Result result) {
        boolean[] anyElement = new boolean[Gnetum.config.numberOfPasses + 1];
        Gnetum.config.mapVanillaElements.forEach((key, value) -> {
            if (value.enabled.get()) {
                anyElement[value.pass] = true;
            }
        });
        Gnetum.config.mapModdedElementsPre.forEach((key, value) -> {
            if (value.enabled.get()) {
                anyElement[value.pass] = true;
            }
        });
        Gnetum.config.mapModdedElementsPost.forEach((key, value) -> {
            if (value.enabled.get()) {
                anyElement[value.pass] = true;
            }
        });
        for (int i = 1; i < anyElement.length; ++i) {
            if (anyElement[i]) continue;
            result.messages.add(I18n.func_135052_a((String)"gnetum.config.analysis.noElement", (Object[])new Object[]{i}));
        }
    }

    private static void analyzeDurations(Result result) {
        long[] durations = Gnetum.passManager.getDurations();
        if (durations == null) {
            return;
        }
        long total = Arrays.stream(durations).skip(1L).sum();
        double avg = (double)total * 1.0 / (double)Gnetum.config.numberOfPasses;
        for (int i = 1; i < durations.length; ++i) {
            if (!((double)durations[i] * 1.0 >= avg * 1.6)) continue;
            long count = 0L;
            int temp = i;
            if ((count += Gnetum.config.mapModdedElementsPre.entrySet().stream().filter(entry -> ((CacheSetting)entry.getValue()).enabled.get() && ((CacheSetting)entry.getValue()).pass == temp).count()) <= 1L) {
                count += Gnetum.config.mapVanillaElements.entrySet().stream().filter(entry -> ((CacheSetting)entry.getValue()).enabled.get() && ((CacheSetting)entry.getValue()).pass == temp).count();
            }
            if (count <= 1L) {
                count += Gnetum.config.mapModdedElementsPost.entrySet().stream().filter(entry -> ((CacheSetting)entry.getValue()).enabled.get() && ((CacheSetting)entry.getValue()).pass == temp).count();
            }
            if (count <= 1L) continue;
            result.messages.add(I18n.func_135052_a((String)"gnetum.config.analysis.longDuration", (Object[])new Object[]{i}));
        }
        Result.access$202(result, durations);
    }

    public static class Result {
        private final List<String> messages = new ArrayList<String>(3);
        private long[] durations;
        private boolean outdated;

        private Result() {
        }

        public ResultIcon getIcon() {
            return this.outdated ? ResultIcon.QUESTION : (this.messages.isEmpty() ? ResultIcon.TICK : ResultIcon.EXCLAMATION);
        }

        public List<String> getMessages() {
            return this.messages;
        }

        public long[] getDurations() {
            return this.durations;
        }

        public boolean isOutdated() {
            return this.outdated;
        }

        public void markOutdated() {
            this.outdated = true;
        }

        static /* synthetic */ long[] access$202(Result x0, long[] x1) {
            x0.durations = x1;
            return x1;
        }
    }

    public static enum ResultIcon {
        TICK,
        EXCLAMATION,
        QUESTION;


        public ResourceLocation icon() {
            ResourceLocation resourceLocation;
            switch (this) {
                case TICK: {
                    resourceLocation = Icons.TICK;
                    break;
                }
                case EXCLAMATION: {
                    resourceLocation = Icons.EXCLAMATION;
                    break;
                }
                case QUESTION: {
                    resourceLocation = Icons.QUESTION;
                    break;
                }
                default: {
                    throw new IncompatibleClassChangeError();
                }
            }
            return resourceLocation;
        }
    }
}

