/*
 * Decompiled with CFR 0.152.
 */
package me.decce.gnetum.hud;

import java.util.function.Supplier;
import me.decce.gnetum.FastResourceLocation;
import me.decce.gnetum.hud.HudManager;
import me.decce.gnetum.hud.SharedValues;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class Hud {
    private final ResourceLocation id;
    private final boolean blend;
    private final boolean defaultBlendFunc;
    private final boolean depth;
    private final boolean dummy;
    private final Supplier<Boolean> condition;
    private final Runnable runnable;

    private Hud(ResourceLocation id, boolean blend, boolean defaultBlendFunc, boolean depth, boolean dummy, Supplier<Boolean> condition, Runnable runnable) {
        this.id = id;
        this.blend = blend;
        this.defaultBlendFunc = defaultBlendFunc;
        this.depth = depth;
        this.dummy = dummy;
        this.condition = condition;
        this.runnable = runnable;
        HudManager.register(this);
    }

    public boolean isDummy() {
        return this.dummy;
    }

    public void render() {
        if (!this.condition.get().booleanValue()) {
            return;
        }
        if (!this.dummy) {
            if (this.blend) {
                GlStateManager.func_179147_l();
            } else {
                GlStateManager.func_179084_k();
            }
            if (this.defaultBlendFunc) {
                SharedValues.defaultBlendFunc();
            }
            if (this.depth) {
                GlStateManager.func_179126_j();
            } else {
                GlStateManager.func_179097_i();
            }
        }
        this.runnable.run();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public ResourceLocation id() {
        return this.id;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ResourceLocation id;
        private boolean blend;
        private boolean defaultBlendFunc;
        private boolean depth;
        private boolean dummy;
        private Supplier<Boolean> condition;
        private Runnable runnable;

        public Builder id(String id) {
            this.id = new FastResourceLocation("minecraft", id);
            return this;
        }

        public Builder id(String namespace, String id) {
            this.id = new FastResourceLocation(namespace, id);
            return this;
        }

        public Builder id(ResourceLocation id) {
            this.id = id;
            return this;
        }

        public Builder blend(boolean blend) {
            this.blend = blend;
            return this;
        }

        public Builder defaultBlendFunc() {
            this.blend = true;
            this.defaultBlendFunc = true;
            return this;
        }

        public Builder depth(boolean depth) {
            this.depth = depth;
            return this;
        }

        public Builder dummy() {
            this.dummy = true;
            return this.id("dummy");
        }

        public Builder condition(Supplier<Boolean> condition) {
            this.condition = condition;
            return this;
        }

        public Builder onRender(Runnable runnable) {
            this.runnable = runnable;
            return this;
        }

        public Hud build() {
            if (this.condition == null) {
                this.condition = () -> true;
            }
            if (this.runnable == null) {
                this.runnable = () -> {};
            }
            return new Hud(this.id, this.blend, this.defaultBlendFunc, this.depth, this.dummy, this.condition, this.runnable);
        }
    }
}

