/*
 * Decompiled with CFR 0.152.
 */
package net.jirniy.pinkstuff.block.entity.custom;

import java.util.Optional;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.jirniy.pinkstuff.block.ModBlocks;
import net.jirniy.pinkstuff.block.entity.ImplementedInventory;
import net.jirniy.pinkstuff.block.entity.ModBlockEntities;
import net.jirniy.pinkstuff.item.ModItems;
import net.jirniy.pinkstuff.recipe.ModRecipes;
import net.jirniy.pinkstuff.recipe.ThermiumBlasterRecipe;
import net.jirniy.pinkstuff.recipe.ThermiumBlasterRecipeInput;
import net.jirniy.pinkstuff.screen.custom.ThermiumBlasterScreenHandler;
import net.jirniy.pinkstuff.util.ModTags;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;

public class ThermiumBlasterBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory<class_2338>,
ImplementedInventory {
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)3, (Object)class_1799.field_8037);
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    private static final int FUEL_SLOT = 2;
    protected final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> ThermiumBlasterBlockEntity.this.progress;
                case 1 -> ThermiumBlasterBlockEntity.this.maxProgress;
                case 2 -> ThermiumBlasterBlockEntity.this.fuel;
                case 3 -> ThermiumBlasterBlockEntity.this.maxFuel;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    ThermiumBlasterBlockEntity.this.progress = value;
                }
                case 1: {
                    ThermiumBlasterBlockEntity.this.maxProgress = value;
                }
                case 2: {
                    ThermiumBlasterBlockEntity.this.fuel = value;
                }
                case 3: {
                    ThermiumBlasterBlockEntity.this.maxFuel = value;
                }
            }
        }

        public int method_17389() {
            return 4;
        }
    };
    private int progress = 0;
    private int maxProgress = 20;
    private int fuel = 0;
    private int maxFuel = 8192;

    @Override
    public boolean method_5493(int slot, class_1799 stack, class_2350 side) {
        return slot == 1;
    }

    @Override
    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 side) {
        if (side != null) {
            if (stack.method_31573(ModTags.Items.THERMIUM_FUEL_INSERTABLE)) {
                return slot == 2;
            }
            return slot == 0;
        }
        return false;
    }

    public ThermiumBlasterBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.THERMIUM_BLASTER_BE, pos, state);
    }

    public class_2338 getScreenOpeningData(class_3222 player) {
        return this.field_11867;
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"block.pinkstuff.thermium_blaster");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new ThermiumBlasterScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    public void method_66473(class_2338 pos, class_2680 oldState) {
        class_1264.method_5451((class_1937)this.field_11863, (class_2338)pos, (class_1263)this);
        super.method_66473(pos, oldState);
    }

    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        class_1262.method_5426((class_11372)view, this.inventory);
        view.method_71465("THERMIUM_BLASTER.progress", this.progress);
        view.method_71465("THERMIUM_BLASTER.max_progress", this.maxProgress);
        view.method_71465("THERMIUM_BLASTER.fuel", this.fuel);
        view.method_71465("THERMIUM_BLASTER.max_fuel", this.maxFuel);
    }

    protected void method_11014(class_11368 view) {
        class_1262.method_5429((class_11368)view, this.inventory);
        this.progress = view.method_71424("THERMIUM_BLASTER.progress", 0);
        this.maxProgress = view.method_71424("THERMIUM_BLASTER.max_progress", 20);
        this.fuel = view.method_71424("THERMIUM_BLASTER.fuel", 0);
        this.maxFuel = view.method_71424("THERMIUM_BLASTER.max_fuel", 8192);
        super.method_11014(view);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        this.addFuel();
        if (this.hasRecipe() && this.isFuelEnoughToCraft()) {
            this.getCookingTime();
            this.increaseCraftingProgress();
            ThermiumBlasterBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
            if (this.hasCraftingFinished()) {
                this.craftItem();
                this.resetProgress();
            }
        } else {
            this.resetProgress();
        }
    }

    private void resetProgress() {
        this.progress = 0;
        this.maxProgress = 4;
    }

    private void craftItem() {
        Optional<class_8786<ThermiumBlasterRecipe>> recipe = this.getCurrentRecipe();
        class_1799 output = ((ThermiumBlasterRecipe)recipe.get().comp_1933()).output();
        int fuelCost = ((ThermiumBlasterRecipe)recipe.get().comp_1933()).fuelCost();
        this.method_5434(0, 1);
        this.method_5447(1, new class_1799((class_1935)output.method_7909(), this.method_5438(1).method_7947() + output.method_7947()));
        this.decreaseFuel(fuelCost);
        this.createWaste(fuelCost);
    }

    private boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    private void createWaste(int fuelCost) {
        class_2338 pos = this.method_11016();
        if (this.method_10997() != null) {
            class_5819 random = this.method_10997().method_8409();
            if (fuelCost % 20 != 0 && random.method_39332(1, fuelCost % 20) == 1) {
                class_1264.method_5449((class_1937)this.method_10997(), (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)new class_1799((class_1935)ModItems.THERMIUM_WASTE, fuelCost / 20 + 1));
            } else {
                class_1264.method_5449((class_1937)this.method_10997(), (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)new class_1799((class_1935)ModItems.THERMIUM_WASTE, fuelCost / 20));
            }
        }
    }

    private void addFuel() {
        class_1799 fuelStack = this.method_5438(2);
        if (!fuelStack.method_7960()) {
            if (fuelStack.method_7909() == ModItems.THERMIUM && this.ableToAddFuel(128)) {
                this.method_5434(2, 1);
                this.fuel += 128;
            } else if (fuelStack.method_7909() == ModItems.THERMIUM_NUGGET && this.ableToAddFuel(16)) {
                this.method_5434(2, 1);
                this.fuel += 16;
            } else if (fuelStack.method_7909() == ModBlocks.THERMIUM_BLOCK.method_8389() && this.ableToAddFuel(1024)) {
                this.method_5434(2, 1);
                this.fuel += 1024;
            } else if (fuelStack.method_7909() == ModItems.ENERGIZED_THERMIUM && this.fuel <= this.maxFuel / 8) {
                this.method_5434(2, 1);
                this.fuel = this.maxFuel;
            }
        }
    }

    private boolean ableToAddFuel(int value) {
        return this.fuel + value <= this.maxFuel;
    }

    private void decreaseFuel(int fuelCost) {
        this.fuel -= fuelCost;
    }

    private boolean hasRecipe() {
        Optional<class_8786<ThermiumBlasterRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        class_1799 output = ((ThermiumBlasterRecipe)recipe.get().comp_1933()).output();
        return this.canInsertAmountIntoOutputSlot(output.method_7947()) && this.canInsertItemIntoOutputSlot(output);
    }

    private void getCookingTime() {
        Optional<class_8786<ThermiumBlasterRecipe>> recipe = this.getCurrentRecipe();
        this.maxProgress = ((ThermiumBlasterRecipe)recipe.get().comp_1933()).cookingTime();
    }

    private boolean isFuelEnoughToCraft() {
        if (this.fuel <= 0) {
            return false;
        }
        Optional<class_8786<ThermiumBlasterRecipe>> recipe = this.getCurrentRecipe();
        int fuelCost = ((ThermiumBlasterRecipe)recipe.get().comp_1933()).fuelCost();
        return this.fuel >= fuelCost;
    }

    private Optional<class_8786<ThermiumBlasterRecipe>> getCurrentRecipe() {
        return ((class_3218)this.method_10997()).method_64577().method_8132(ModRecipes.THERMIUM_BLASTER_TYPE, (class_9695)new ThermiumBlasterRecipeInput((class_1799)this.inventory.get(0)), this.method_10997());
    }

    private boolean canInsertItemIntoOutputSlot(class_1799 output) {
        return this.method_5438(1).method_7960() || this.method_5438(1).method_7909() == output.method_7909();
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        int maxCount = this.method_5438(1).method_7960() ? 64 : this.method_5438(1).method_7914();
        int currentCount = this.method_5438(1).method_7947();
        return maxCount >= currentCount + count;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_38244(registryLookup);
    }
}

