/*
 * Decompiled with CFR 0.152.
 */
package net.jirniy.pinkstuff.item.custom;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.jirniy.pinkstuff.effect.ModEffects;
import net.jirniy.pinkstuff.item.ModArmorMaterials;
import net.jirniy.pinkstuff.particle.ModParticles;
import net.minecraft.class_10192;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2394;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class ModArmorItem
extends class_1792 {
    private static final Map<class_1741, List<class_1293>> MATERIAL_TO_EFFECT_MAP = new ImmutableMap.Builder().put((Object)ModArmorMaterials.ELYSIUM_ARMOR_MATERIAL, List.of(new class_1293(class_1294.field_5914, 5, 0, true, true), new class_1293(class_1294.field_5924, 5, 0, true, true))).put((Object)ModArmorMaterials.PINLINE_ARMOR_MATERIAL, List.of(new class_1293(ModEffects.GROUNDED, 5, 0, true, true), new class_1293(class_1294.field_5917, 5, 2, true, true))).put((Object)ModArmorMaterials.CERILLE_ARMOR_MATERIAL, List.of(new class_1293(class_1294.field_5910, 5, 0, true, true), new class_1293(class_1294.field_5904, 5, 1, true, true))).put((Object)ModArmorMaterials.SUNBLAZE_ARMOR_MATERIAL, List.of(new class_1293(class_1294.field_5918, 5, 0, true, true))).build();

    public ModArmorItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
        class_1657 player;
        if (!world.method_8608() && entity instanceof class_1657 && this.hasFullSuitOfArmorOn(player = (class_1657)entity)) {
            this.evaluateArmorEffects(player, world);
        }
        super.method_7888(stack, world, entity, slot);
    }

    private void evaluateArmorEffects(class_1657 player, class_3218 world) {
        for (Map.Entry<class_1741, List<class_1293>> entry : MATERIAL_TO_EFFECT_MAP.entrySet()) {
            class_1741 mapArmorMaterial = entry.getKey();
            List<class_1293> mapStatusEffects = entry.getValue();
            if (!this.hasCorrectArmorOn(mapArmorMaterial, player)) continue;
            this.addParticle(player, world);
            this.addStatusEffectForMaterial(player, mapArmorMaterial, mapStatusEffects);
        }
    }

    private void addParticle(class_1657 player, class_3218 world) {
        if (player.method_59922().method_39332(1, 32) == 1) {
            world.method_65096((class_2394)ModParticles.SPARKLE_PARTICLE, player.method_23317(), player.method_23318() + (double)(player.method_17682() / 2.0f), player.method_23321(), 1, (double)(player.method_17681() / 2.0f) + 0.1, (double)(player.method_17682() / 2.0f), (double)(player.method_17681() / 2.0f) + 0.1, 1.0);
        }
    }

    private void addStatusEffectForMaterial(class_1657 player, class_1741 mapArmorMaterial, List<class_1293> mapStatusEffect) {
        for (class_1293 instance : mapStatusEffect) {
            if (player.method_6059(instance.method_5579()) && player.method_6112(instance.method_5579()).method_5578() > instance.method_5578()) continue;
            player.method_6092(new class_1293(instance.method_5579(), instance.method_5584(), instance.method_5578(), instance.method_5591(), instance.method_5581()));
        }
    }

    private boolean hasFullSuitOfArmorOn(class_1657 player) {
        class_1799 boots = player.method_6118(class_1304.field_6166);
        class_1799 leggings = player.method_6118(class_1304.field_6172);
        class_1799 chestplate = player.method_6118(class_1304.field_6174);
        class_1799 helmet = player.method_6118(class_1304.field_6169);
        return !helmet.method_7960() && !chestplate.method_7960() && !leggings.method_7960() && !boots.method_7960();
    }

    private boolean hasCorrectArmorOn(class_1741 material, class_1657 player) {
        class_1799 boots = player.method_6118(class_1304.field_6166);
        class_1799 leggings = player.method_6118(class_1304.field_6172);
        class_1799 chestplate = player.method_6118(class_1304.field_6174);
        class_1799 helmet = player.method_6118(class_1304.field_6169);
        class_10192 equippableComponentBoots = (class_10192)boots.method_57353().method_58694(class_9334.field_54196);
        class_10192 equippableComponentLeggings = (class_10192)leggings.method_57353().method_58694(class_9334.field_54196);
        class_10192 equippableComponentBreastplate = (class_10192)chestplate.method_57353().method_58694(class_9334.field_54196);
        class_10192 equippableComponentHelmet = (class_10192)helmet.method_57353().method_58694(class_9334.field_54196);
        return ((class_5321)equippableComponentBoots.comp_3176().get()).equals(material.comp_3168()) && ((class_5321)equippableComponentLeggings.comp_3176().get()).equals(material.comp_3168()) && ((class_5321)equippableComponentBreastplate.comp_3176().get()).equals(material.comp_3168()) && ((class_5321)equippableComponentHelmet.comp_3176().get()).equals(material.comp_3168());
    }
}

