/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oelib.client.renderer;

import com.mafuyu404.oelib.api.client.renderer.FluidRenderersSPI;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ServiceLoader;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public final class FluidRenderers {
    public static final int TEXTURE_SIZE = 16;
    public static final int MIN_FLUID_HEIGHT = 1;
    private static final FluidRenderersSPI IMPL = ServiceLoader.load(FluidRenderersSPI.class).findFirst().orElseThrow(() -> new IllegalStateException("No FluidRenderersSPI implementation found"));

    private FluidRenderers() {
    }

    public static void render(GuiGraphics graphics, Object fluidRef, long amount, long capacity, int x, int y, int width, int height) {
        IMPL.render(graphics, fluidRef, amount, capacity, x, y, width, height);
    }

    public static int computeScaledHeight(long amount, long capacity, int fullHeight, int minHeight) {
        if (capacity <= 0L || fullHeight <= 0) {
            return 0;
        }
        long scaled = amount * (long)fullHeight / capacity;
        if (amount > 0L && scaled < (long)minHeight) {
            scaled = minHeight;
        }
        if (scaled > (long)fullHeight) {
            scaled = fullHeight;
        }
        return (int)scaled;
    }

    public static void renderTiledSprite(GuiGraphics graphics, TextureAtlasSprite sprite, int colorARGB, int x, int y, int width, int scaledHeight, int fullHeight) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.m_247685_());
        RenderSystem.setShaderColor((float)((float)(colorARGB >> 16 & 0xFF) / 255.0f), (float)((float)(colorARGB >> 8 & 0xFF) / 255.0f), (float)((float)(colorARGB & 0xFF) / 255.0f), (float)((float)(colorARGB >> 24 & 0xFF) / 255.0f));
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        int yStart = y + fullHeight;
        int xTileCount = width / 16;
        int xRemainder = width - xTileCount * 16;
        int yTileCount = scaledHeight / 16;
        int yRemainder = scaledHeight - yTileCount * 16;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int tileHeight;
                int tileWidth = xTile == xTileCount ? xRemainder : 16;
                int n = tileHeight = yTile == yTileCount ? yRemainder : 16;
                if (tileWidth <= 0 || tileHeight <= 0) continue;
                int drawX = x + xTile * 16;
                int drawY = yStart - (yTile + 1) * 16;
                float uMin = sprite.m_118409_();
                float uMax = sprite.m_118410_();
                float vMin = sprite.m_118411_();
                float vMax = sprite.m_118412_();
                uMax -= (float)(16 - tileWidth) / 16.0f * (uMax - uMin);
                vMax -= (float)(16 - tileHeight) / 16.0f * (vMax - vMin);
                Tesselator tess = Tesselator.m_85913_();
                BufferBuilder buf = tess.m_85915_();
                buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                buf.m_252986_(matrix, (float)drawX, (float)(drawY + tileHeight), 100.0f).m_7421_(uMin, vMax).m_5752_();
                buf.m_252986_(matrix, (float)(drawX + tileWidth), (float)(drawY + tileHeight), 100.0f).m_7421_(uMax, vMax).m_5752_();
                buf.m_252986_(matrix, (float)(drawX + tileWidth), (float)drawY, 100.0f).m_7421_(uMax, vMin).m_5752_();
                buf.m_252986_(matrix, (float)drawX, (float)drawY, 100.0f).m_7421_(uMin, vMin).m_5752_();
                tess.m_85914_();
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }
}

