/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oelib.forge.client.renderer;

import com.mafuyu404.oelib.api.client.renderer.FluidRenderersSPI;
import com.mafuyu404.oelib.client.renderer.FluidRenderers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;

public final class FluidRenderersImpl
implements FluidRenderersSPI {
    @Override
    public void render(GuiGraphics graphics, Object fluidRef, long amount, long capacity, int x, int y, int width, int height) {
        if (!(fluidRef instanceof FluidStack)) {
            return;
        }
        FluidStack stack = (FluidStack)fluidRef;
        if (stack.isEmpty() || stack.getFluid() == Fluids.f_76191_) {
            return;
        }
        IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((Fluid)stack.getFluid());
        int color = props.getTintColor(stack);
        ResourceLocation stillTex = props.getStillTexture(stack);
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(stillTex);
        if (sprite.m_247685_() == MissingTextureAtlasSprite.m_118071_()) {
            return;
        }
        int scaledHeight = FluidRenderers.computeScaledHeight(amount, capacity, height, 1);
        FluidRenderers.renderTiledSprite(graphics, sprite, color, x, y, width, scaledHeight, height);
    }
}

