/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oelib.icon;

import java.util.Objects;

public final class IconVariant {
    private final String name;
    private final String path;
    private final int weight;
    private final Platform platform;

    private IconVariant(String name, String path, int weight, Platform platform) {
        this.name = name;
        this.path = path;
        this.weight = Math.max(1, weight);
        this.platform = platform;
    }

    public static IconVariant name(String name, int weight) {
        return new IconVariant(Objects.requireNonNull(name), null, weight, Platform.COMMON);
    }

    public static IconVariant path(String path, int weight) {
        return new IconVariant(null, Objects.requireNonNull(path), weight, Platform.COMMON);
    }

    public static IconVariant nameFabric(String name, int weight) {
        return new IconVariant(Objects.requireNonNull(name), null, weight, Platform.FABRIC);
    }

    public static IconVariant pathFabric(String path, int weight) {
        return new IconVariant(null, Objects.requireNonNull(path), weight, Platform.FABRIC);
    }

    public static IconVariant nameForge(String name, int weight) {
        return new IconVariant(Objects.requireNonNull(name), null, weight, Platform.FORGE);
    }

    public static IconVariant pathForge(String path, int weight) {
        return new IconVariant(null, Objects.requireNonNull(path), weight, Platform.FORGE);
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public int getWeight() {
        return this.weight;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    boolean isName() {
        return this.name != null;
    }

    boolean isPath() {
        return this.path != null;
    }

    boolean appliesToFabric() {
        return this.platform == Platform.COMMON || this.platform == Platform.FABRIC;
    }

    boolean appliesToForge() {
        return this.platform == Platform.COMMON || this.platform == Platform.FORGE;
    }

    public static enum Platform {
        COMMON,
        FABRIC,
        FORGE;

    }
}

