/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oelib.api.data;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;

public interface DataValidator<T> {
    public ValidationResult validate(T var1, ResourceLocation var2);

    public static class NoValidator
    implements DataValidator<Object> {
        @Override
        public ValidationResult validate(Object data, ResourceLocation source) {
            return ValidationResult.success();
        }
    }

    public record ValidationResult(boolean valid, String message, boolean deferrable) {
        public static ValidationResult success() {
            return new ValidationResult(true, null, false);
        }

        public static ValidationResult failure(String message) {
            return new ValidationResult(false, message, false);
        }

        public static ValidationResult deferred(String message) {
            return new ValidationResult(true, message, true);
        }
    }

    public static interface ServerContextAware<T>
    extends DataValidator<T> {
        public ValidationResult validateWithContext(T var1, ResourceLocation var2, MinecraftServer var3);

        @Override
        default public ValidationResult validate(T data, ResourceLocation source) {
            return this.validateWithContext(data, source, null);
        }
    }
}

