/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oelib.api.net;

import com.mafuyu404.oelib.api.net.INetworkContext;
import com.mafuyu404.oelib.api.net.INetworkPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public interface SimplePacket<T extends SimplePacket<T> & CustomPacketPayload>
extends INetworkPacket<T> {
    public String getModId();

    default public CustomPacketPayload.Type<T> type() {
        String className = this.getClass().getSimpleName().toLowerCase();
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)this.getModId(), (String)className);
        return new CustomPacketPayload.Type(id);
    }

    default public boolean isClientSide(INetworkContext context) {
        return context.isClientSide();
    }

    default public boolean isServerSide(INetworkContext context) {
        return context.isServerSide();
    }

    default public ServerPlayer getSender(INetworkContext context) {
        return context.sender();
    }

    default public Minecraft getClient(INetworkContext context) {
        return context.client();
    }

    default public void handleClient(INetworkContext context) {
    }

    default public void handleServer(INetworkContext context) {
    }

    @Override
    default public void handle(INetworkContext context) {
        if (this.isClientSide(context)) {
            this.handleClient(context);
        } else {
            this.handleServer(context);
        }
    }
}

