/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oelib.data;

import com.mafuyu404.oelib.api.data.DataManagerBridgeSPI;
import com.mafuyu404.oelib.api.data.DataValidator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public final class DataManagerBridge {
    private static final DataManagerBridgeSPI IMPL = ServiceLoader.load(DataManagerBridgeSPI.class).findFirst().orElseThrow(() -> new IllegalStateException("No DataManagerBridgeSPI implementation found"));

    private DataManagerBridge() {
    }

    public static <T> void register(Class<T> dataClass) {
        IMPL.register(dataClass);
    }

    public static <T> void registerNamespace(Class<T> dataClass, String namespace) {
        IMPL.registerNamespace(dataClass, namespace);
    }

    public static <T> void registerNamespaceValidator(Class<T> dataClass, String namespace, Class<? extends DataValidator<?>> validatorClass) {
        IMPL.registerNamespaceValidator(dataClass, namespace, validatorClass);
    }

    public static <T> Map<ResourceLocation, T> getAllData(Class<T> dataClass) {
        return IMPL.getAllData(dataClass);
    }

    public static <T> T getData(Class<T> dataClass, ResourceLocation location) {
        return IMPL.getData(dataClass, location);
    }

    public static <T> List<T> getDataList(Class<T> dataClass) {
        return IMPL.getDataList(dataClass);
    }

    public static <T> Set<T> getCachedData(Class<T> dataClass, String cacheKey) {
        return IMPL.getCachedData(dataClass, cacheKey);
    }

    public static <T> void addToCache(Class<T> dataClass, String cacheKey, T data) {
        IMPL.addToCache(dataClass, cacheKey, data);
    }

    public static <T> void clearCache(Class<T> dataClass) {
        IMPL.clearCache(dataClass);
    }

    public static <T> void updateClientData(Class<T> dataClass, Map<ResourceLocation, T> data) {
        IMPL.updateClientData(dataClass, data);
    }

    public static boolean isModLoaded(String modid) {
        return IMPL.isModLoaded(modid);
    }
}

