/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oelib.data;

import com.mafuyu404.oelib.OELib;
import com.mafuyu404.oelib.api.data.DataDriven;
import com.mafuyu404.oelib.api.data.DataValidator;
import com.mafuyu404.oelib.data.DataManagerBridge;
import com.mafuyu404.oelib.data.mvel.ExpressionEngine;
import com.mafuyu404.oelib.data.mvel.FunctionUsageAnalyzer;
import com.mafuyu404.oelib.util.CodecUtils;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public final class DataRegistry {
    private static final Map<Class<?>, Integer> registeredTypes = new ConcurrentHashMap();
    private static final Map<Class<?>, FunctionUsageAnalyzer.DataExpressionExtractor<?>> extractors = new ConcurrentHashMap();
    private static boolean initialized = false;
    private static boolean expressionEngineInitialized = false;

    private DataRegistry() {
    }

    public static <T> void register(Class<T> dataClass) {
        DataRegistry.registerInternal(dataClass, null, null);
    }

    public static <T> void register(Class<T> dataClass, Codec<T> codec) {
        DataRegistry.registerInternal(dataClass, codec, null);
    }

    public static <T> void registerWithNamespaces(Class<T> dataClass, String ... namespaces) {
        DataRegistry.registerInternal(dataClass, null, namespaces);
    }

    public static <T> void registerWithNamespaces(Class<T> dataClass, Codec<T> codec, String ... namespaces) {
        DataRegistry.registerInternal(dataClass, codec, namespaces);
    }

    public static <T> void registerNamespaceValidator(Class<T> dataClass, String namespace, Class<? extends DataValidator<?>> validatorClass) {
        if (!DataRegistry.isRegistered(dataClass)) {
            throw new IllegalStateException("Cannot register namespace validator for unregistered data class: " + dataClass.getSimpleName() + ". Please register the data type first using DataRegistry.register(...).");
        }
        DataManagerBridge.registerNamespaceValidator(dataClass, namespace, validatorClass);
        OELib.LOGGER.debug("Registered namespace validator {} for {} in namespace '{}'", new Object[]{validatorClass.getSimpleName(), dataClass.getSimpleName(), namespace});
    }

    private static <T> void registerInternal(Class<T> dataClass, @Nullable Codec<T> codec, String ... namespaces) {
        if (!dataClass.isAnnotationPresent(DataDriven.class)) {
            throw new IllegalArgumentException("Class " + dataClass.getSimpleName() + " must be annotated with @DataDriven");
        }
        DataDriven annotation = dataClass.getAnnotation(DataDriven.class);
        int priority = annotation.priority();
        registeredTypes.put(dataClass, priority);
        String codecInfo = "none";
        if (codec != null) {
            CodecUtils.registerCodec(dataClass, codec);
            codecInfo = codec.getClass().getSimpleName();
        }
        DataManagerBridge.register(dataClass);
        ArrayList<String> registeredNamespaces = new ArrayList<String>();
        if (namespaces != null) {
            for (String ns : namespaces) {
                if (ns == null || ns.isBlank()) continue;
                DataManagerBridge.registerNamespace(dataClass, ns);
                registeredNamespaces.add(ns);
            }
        }
        if (!registeredNamespaces.isEmpty()) {
            OELib.LOGGER.debug("Registered data-driven type: {} | Priority: {} | Codec: {} | Namespaces: {}", new Object[]{dataClass.getSimpleName(), priority, codecInfo, registeredNamespaces});
        } else {
            OELib.LOGGER.debug("Registered data-driven type: {} | Priority: {} | Codec: {}", new Object[]{dataClass.getSimpleName(), priority, codecInfo});
        }
    }

    public static <T> void registerExtractor(Class<T> dataClass, FunctionUsageAnalyzer.DataExpressionExtractor<T> extractor) {
        extractors.put(dataClass, extractor);
        OELib.LOGGER.debug("Registered expression extractor for: {}", (Object)dataClass.getSimpleName());
    }

    public static void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        OELib.LOGGER.info("Data registry initialized with {} registered types", (Object)registeredTypes.size());
    }

    public static void initializeExpressionEngine() {
        ExpressionEngine.clear();
        expressionEngineInitialized = false;
        HashSet<String> allUsedFunctions = new HashSet<String>(FunctionUsageAnalyzer.getCoreRequiredFunctions());
        boolean hasAnyData = false;
        List<Class<?>> sortedTypes = DataRegistry.getRegisteredTypesByPriority();
        OELib.LOGGER.debug("Processing data types in priority order: {}", (Object)sortedTypes.stream().map(clazz -> clazz.getSimpleName() + "(priority:" + String.valueOf(registeredTypes.get(clazz)) + ")").collect(Collectors.joining(", ")));
        for (Class<?> dataClass : sortedTypes) {
            Map<ResourceLocation, ?> data;
            FunctionUsageAnalyzer.DataExpressionExtractor<?> extractor = extractors.get(dataClass);
            if (extractor == null || (data = DataManagerBridge.getAllData(dataClass)) == null || data.isEmpty()) continue;
            hasAnyData = true;
            Set<String> usedFunctions = FunctionUsageAnalyzer.analyzeUsedFunctions(data, extractor);
            allUsedFunctions.addAll(usedFunctions);
            OELib.LOGGER.debug("Found {} functions in {} (priority:{}): {}", new Object[]{usedFunctions.size(), dataClass.getSimpleName(), registeredTypes.get(dataClass), usedFunctions});
        }
        if (!hasAnyData) {
            OELib.LOGGER.info("No datapack data loaded yet; deferring expression engine initialization");
            return;
        }
        OELib.LOGGER.info("Smart registration: found {} total used functions: {}", (Object)allUsedFunctions.size(), allUsedFunctions);
        ExpressionEngine.initialize(allUsedFunctions);
        expressionEngineInitialized = true;
    }

    public static Set<Class<?>> getRegisteredTypes() {
        return Set.copyOf(registeredTypes.keySet());
    }

    public static List<Class<?>> getRegisteredTypesByPriority() {
        return registeredTypes.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public static Integer getPriority(Class<?> dataClass) {
        return registeredTypes.get(dataClass);
    }

    public static boolean isRegistered(Class<?> dataClass) {
        return registeredTypes.containsKey(dataClass);
    }

    public static boolean isExpressionEngineInitialized() {
        return expressionEngineInitialized;
    }

    public static void resetExpressionEngine() {
        expressionEngineInitialized = false;
        ExpressionEngine.clear();
    }
}

