/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oelib.neoforge.data;

import com.mafuyu404.oelib.api.data.DataManagerBridgeSPI;
import com.mafuyu404.oelib.api.data.DataValidator;
import com.mafuyu404.oelib.data.DataRegistry;
import com.mafuyu404.oelib.neoforge.data.DataManager;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddReloadListenerEvent;

@EventBusSubscriber(modid="oelib")
public final class DataManagerBridgeImpl
implements DataManagerBridgeSPI {
    @Override
    public <T> void register(Class<T> dataClass) {
        DataManager.register(dataClass);
    }

    @Override
    public <T> void registerNamespace(Class<T> dataClass, String namespace) {
        DataManager.registerNamespace(dataClass, namespace);
    }

    @Override
    public <T> void registerNamespaceValidator(Class<T> dataClass, String namespace, Class<? extends DataValidator<?>> validatorClass) {
        DataManager.registerNamespaceValidator(dataClass, namespace, validatorClass);
    }

    @Override
    public <T> Map<ResourceLocation, T> getAllData(Class<T> dataClass) {
        DataManager<T> manager = DataManager.get(dataClass);
        return manager != null ? manager.getAllData() : Map.of();
    }

    @SubscribeEvent
    public static void onAddReloadListener(AddReloadListenerEvent event) {
        List<Class<?>> types = DataRegistry.getRegisteredTypesByPriority();
        for (Class<?> dataClass : types) {
            DataManager<?> manager = DataManager.get(dataClass);
            if (manager == null) continue;
            event.addListener(manager);
        }
    }

    @Override
    public <T> T getData(Class<T> dataClass, ResourceLocation location) {
        DataManager<T> manager = DataManager.get(dataClass);
        return manager != null ? (T)manager.getData(location) : null;
    }

    @Override
    public <T> List<T> getDataList(Class<T> dataClass) {
        DataManager<T> manager = DataManager.get(dataClass);
        return manager != null ? manager.getDataList() : List.of();
    }

    @Override
    public <T> Set<T> getCachedData(Class<T> dataClass, String cacheKey) {
        DataManager<T> manager = DataManager.get(dataClass);
        return manager != null ? manager.getCachedData(cacheKey) : Set.of();
    }

    @Override
    public <T> void addToCache(Class<T> dataClass, String cacheKey, T data) {
        DataManager<T> manager = DataManager.get(dataClass);
        if (manager != null) {
            manager.addToCache(cacheKey, data);
        }
    }

    @Override
    public <T> void clearCache(Class<T> dataClass) {
        DataManager<T> manager = DataManager.get(dataClass);
        if (manager != null) {
            manager.clearCache();
        }
    }

    @Override
    public <T> void updateClientData(Class<T> dataClass, Map<ResourceLocation, T> data) {
        DataManager<T> manager = DataManager.get(dataClass);
        if (manager != null) {
            manager.updateClientData(data);
        }
    }

    @Override
    public boolean isModLoaded(String modid) {
        return ModList.get().isLoaded(modid);
    }
}

