/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oelib.neoforge.data.net;

import com.mafuyu404.oelib.OELib;
import com.mafuyu404.oelib.api.net.INetworkContext;
import com.mafuyu404.oelib.api.net.NetworkPacket;
import com.mafuyu404.oelib.api.net.Side;
import com.mafuyu404.oelib.api.net.SimplePacket;
import com.mafuyu404.oelib.neoforge.network.ChunkAssembler;
import com.mojang.serialization.Codec;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

@NetworkPacket(side=Side.BOTH, chunkThreshold=30000)
public record DataSyncChunkPacket(UUID sessionId, int chunkIndex, int totalChunks, String dataClassName, byte[] chunkData) implements SimplePacket<DataSyncChunkPacket>
{
    public static final StreamCodec<FriendlyByteBuf, DataSyncChunkPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.fromCodec((Codec)UUIDUtil.CODEC), DataSyncChunkPacket::sessionId, (StreamCodec)ByteBufCodecs.VAR_INT, DataSyncChunkPacket::chunkIndex, (StreamCodec)ByteBufCodecs.VAR_INT, DataSyncChunkPacket::totalChunks, (StreamCodec)ByteBufCodecs.STRING_UTF8, DataSyncChunkPacket::dataClassName, (StreamCodec)ByteBufCodecs.BYTE_ARRAY, DataSyncChunkPacket::chunkData, DataSyncChunkPacket::new);

    @Override
    public String getModId() {
        return "oelib";
    }

    @Override
    public void handle(INetworkContext context) {
        try {
            ChunkAssembler.receiveChunk(this.sessionId, this.chunkIndex, this.totalChunks, this.dataClassName, this.chunkData);
        }
        catch (Exception e) {
            OELib.LOGGER.error("Failed to handle chunk packet: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

