/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oelib.neoforge.data.net;

import com.mafuyu404.oelib.OELib;
import com.mafuyu404.oelib.neoforge.data.net.DataSyncChunkPacket;
import com.mafuyu404.oelib.util.CodecUtils;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class DataSyncPacket<T> {
    private final Class<T> dataClass;
    private final Map<ResourceLocation, T> data;

    public DataSyncPacket(Class<T> dataClass, Map<ResourceLocation, T> data) {
        this.dataClass = dataClass;
        this.data = data;
    }

    public void sendTo(ServerPlayer player) {
        if (player == null) {
            OELib.LOGGER.warn("Cannot send packet: player is null");
            return;
        }
        try {
            Optional<String> jsonOpt = CodecUtils.encodeToJson(this.dataClass, this.data);
            if (jsonOpt.isEmpty()) {
                OELib.LOGGER.error("Failed to encode {} data to JSON", (Object)this.dataClass.getSimpleName());
                return;
            }
            byte[] dataBytes = jsonOpt.get().getBytes(StandardCharsets.UTF_8);
            OELib.LOGGER.info("Sending {} data: {} entries, {} bytes", new Object[]{this.dataClass.getSimpleName(), this.data.size(), dataBytes.length});
            DataSyncChunkPacket packet = new DataSyncChunkPacket(UUID.randomUUID(), 0, 1, this.dataClass.getName(), dataBytes);
            packet.sendToWithChunking(player);
        }
        catch (Exception e) {
            OELib.LOGGER.error("Failed to send {} sync packet: {}", new Object[]{this.dataClass.getSimpleName(), e.getMessage(), e});
        }
    }

    public void sendToAll() {
        try {
            Optional<String> jsonOpt = CodecUtils.encodeToJson(this.dataClass, this.data);
            if (jsonOpt.isEmpty()) {
                OELib.LOGGER.error("Failed to encode {} data to JSON", (Object)this.dataClass.getSimpleName());
                return;
            }
            byte[] dataBytes = jsonOpt.get().getBytes(StandardCharsets.UTF_8);
            OELib.LOGGER.info("Sending {} data to all players: {} entries, {} bytes", new Object[]{this.dataClass.getSimpleName(), this.data.size(), dataBytes.length});
            DataSyncChunkPacket packet = new DataSyncChunkPacket(UUID.randomUUID(), 0, 1, this.dataClass.getName(), dataBytes);
            packet.sendToAllWithChunking();
        }
        catch (Exception e) {
            OELib.LOGGER.error("Failed to send {} sync packet to all players: {}", new Object[]{this.dataClass.getSimpleName(), e.getMessage(), e});
        }
    }
}

