/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oelib.neoforge.network;

import com.mafuyu404.oelib.OELib;
import com.mafuyu404.oelib.neoforge.data.DataManager;
import com.mafuyu404.oelib.util.CodecUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.resources.ResourceLocation;

public class ChunkAssembler {
    private static final Map<UUID, AssemblySession> assemblingSessions = new ConcurrentHashMap<UUID, AssemblySession>();
    private static final ScheduledExecutorService cleanupExecutor = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = new Thread(r, "ChunkAssembler-Cleanup");
        t.setDaemon(true);
        return t;
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void receiveChunk(UUID sessionId, int chunkIndex, int totalChunks, String dataClassName, byte[] chunkData) {
        AssemblySession session = assemblingSessions.computeIfAbsent(sessionId, id -> new AssemblySession(totalChunks, dataClassName));
        if (session.addChunk(chunkIndex, chunkData)) {
            try {
                byte[] completeData = session.assembleData();
                String jsonData = new String(completeData, StandardCharsets.UTF_8);
                Class<?> dataClass = Class.forName(dataClassName);
                Optional<Map<ResourceLocation, ?>> dataOpt = CodecUtils.decodeFromJson(dataClass, jsonData);
                if (dataOpt.isPresent()) {
                    Map<ResourceLocation, ?> data = dataOpt.get();
                    DataManager<?> manager = DataManager.get(dataClass);
                    if (manager != null) {
                        ChunkAssembler.updateClientData(manager, data);
                        OELib.LOGGER.info("Successfully processed {} {} data entries", (Object)data.size(), (Object)dataClass.getSimpleName());
                    } else {
                        OELib.LOGGER.error("No data manager found for {}", (Object)dataClass.getSimpleName());
                    }
                } else {
                    OELib.LOGGER.error("Failed to parse JSON data for {} session {}", (Object)dataClassName, (Object)sessionId);
                }
            }
            catch (Exception e) {
                OELib.LOGGER.error("Failed to assemble chunk data for {} session {}: {}", new Object[]{dataClassName, sessionId, e.getMessage(), e});
            }
            finally {
                assemblingSessions.remove(sessionId);
            }
        }
    }

    private static <T> void updateClientData(DataManager<T> manager, Map<ResourceLocation, ?> data) {
        manager.updateClientData(data);
    }

    private static void cleanupExpiredSessions() {
        long currentTime = System.currentTimeMillis();
        assemblingSessions.entrySet().removeIf(entry -> {
            boolean expired;
            boolean bl = expired = currentTime - ((AssemblySession)entry.getValue()).getCreationTime() > 60000L;
            if (expired) {
                OELib.LOGGER.debug("Cleaning up expired assembly session: {}", entry.getKey());
            }
            return expired;
        });
    }

    static {
        cleanupExecutor.scheduleAtFixedRate(ChunkAssembler::cleanupExpiredSessions, 30L, 30L, TimeUnit.SECONDS);
    }

    private static class AssemblySession {
        private final int totalChunks;
        private final String dataClassName;
        private final byte[][] chunks;
        private final boolean[] received;
        private final long creationTime;
        private int receivedCount = 0;

        public AssemblySession(int totalChunks, String dataClassName) {
            this.totalChunks = totalChunks;
            this.dataClassName = dataClassName;
            this.chunks = new byte[totalChunks][];
            this.received = new boolean[totalChunks];
            this.creationTime = System.currentTimeMillis();
        }

        public synchronized boolean addChunk(int chunkIndex, byte[] chunkData) {
            if (chunkIndex < 0 || chunkIndex >= this.totalChunks) {
                OELib.LOGGER.warn("Invalid chunk index: {} (total: {}) for {}", new Object[]{chunkIndex, this.totalChunks, this.dataClassName});
                return false;
            }
            if (!this.received[chunkIndex]) {
                this.chunks[chunkIndex] = chunkData;
                this.received[chunkIndex] = true;
                ++this.receivedCount;
            }
            return this.receivedCount == this.totalChunks;
        }

        public byte[] assembleData() throws IOException {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            for (int i = 0; i < this.totalChunks; ++i) {
                if (this.chunks[i] == null) {
                    throw new IOException("Missing chunk: " + i + " for " + this.dataClassName);
                }
                output.write(this.chunks[i]);
            }
            return output.toByteArray();
        }

        public long getCreationTime() {
            return this.creationTime;
        }
    }
}

