/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oelib.neoforge.network;

import com.mafuyu404.oelib.OELib;
import com.mafuyu404.oelib.api.net.INetworkManager;
import com.mafuyu404.oelib.api.net.INetworkPacket;
import com.mafuyu404.oelib.api.net.NetworkPacket;
import com.mafuyu404.oelib.api.net.SimplePacket;
import com.mafuyu404.oelib.neoforge.data.DataManager;
import com.mafuyu404.oelib.neoforge.data.net.DataSyncChunkPacket;
import com.mafuyu404.oelib.neoforge.network.NeoForgeNetworkContext;
import io.netty.buffer.Unpooled;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@EventBusSubscriber(modid="oelib")
public class NetworkManager
implements INetworkManager {
    private static final String PROTOCOL_VERSION = "1";
    private static final Map<CustomPacketPayload.Type<?>, PacketInfo<?>> registeredPackets = new ConcurrentHashMap();
    private static PayloadRegistrar registrar;
    private static NetworkManager instance;

    @SubscribeEvent
    public static void initialize(RegisterPayloadHandlersEvent event) {
        registrar = event.registrar("oelib").versioned(PROTOCOL_VERSION);
        instance = new NetworkManager();
        com.mafuyu404.oelib.api.net.NetworkManager.setInstance(instance);
        NetworkManager.registerBuiltinPackets();
        OELib.LOGGER.info("Network manager initialized");
    }

    @Override
    public <T extends INetworkPacket<T> & CustomPacketPayload> void registerBidirectionalPacket(Class<T> packetClass, StreamCodec<? super RegistryFriendlyByteBuf, T> codec) {
        if (registrar == null) {
            throw new IllegalStateException("Network manager not initialized");
        }
        try {
            CustomPacketPayload.Type<T> type = this.createPacketType(packetClass);
            if (registeredPackets.containsKey(type)) {
                OELib.LOGGER.warn("Packet {} is already registered, skipping", (Object)type.id());
                return;
            }
            PacketInfo<T> info = new PacketInfo<T>(type, codec);
            registeredPackets.put(type, info);
            registrar.playBidirectional(type, codec, (packet, context) -> context.enqueueWork(() -> {
                NeoForgeNetworkContext networkContext = new NeoForgeNetworkContext(context);
                packet.handle(networkContext);
            }));
            OELib.LOGGER.info("Registered network packet: {} (ID: {})", (Object)type.id().getPath(), (Object)type.id());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to register packet " + packetClass.getSimpleName(), e);
        }
    }

    @Override
    public void registerBidirectionalPackets(INetworkManager.PacketRegistration<?> ... packets) {
        for (INetworkManager.PacketRegistration<?> packet : packets) {
            this.registerBidirectionalPacketUnchecked(packet.packetClass(), packet.codec());
        }
    }

    @Override
    public <T extends INetworkPacket<T> & CustomPacketPayload> void registerClientPacket(Class<T> packetClass, StreamCodec<? super RegistryFriendlyByteBuf, T> codec) {
        if (registrar == null) {
            throw new IllegalStateException("Network manager not initialized");
        }
        try {
            CustomPacketPayload.Type<T> type = this.createPacketType(packetClass);
            registrar.playToClient(type, codec, (packet, context) -> context.enqueueWork(() -> {
                NeoForgeNetworkContext networkContext = new NeoForgeNetworkContext(context);
                packet.handle(networkContext);
            }));
            OELib.LOGGER.info("Registered client network packet: {} (ID: {})", (Object)type.id().getPath(), (Object)type.id());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to register client packet " + packetClass.getSimpleName(), e);
        }
    }

    @Override
    public void registerClientPackets(INetworkManager.PacketRegistration<?> ... packets) {
        for (INetworkManager.PacketRegistration<?> packet : packets) {
            this.registerClientPacketUnchecked(packet.packetClass(), packet.codec());
        }
    }

    @Override
    public <T extends INetworkPacket<T> & CustomPacketPayload> void registerServerPacket(Class<T> packetClass, StreamCodec<? super RegistryFriendlyByteBuf, T> codec) {
        if (registrar == null) {
            throw new IllegalStateException("Network manager not initialized");
        }
        try {
            CustomPacketPayload.Type<T> type = this.createPacketType(packetClass);
            registrar.playToServer(type, codec, (packet, context) -> context.enqueueWork(() -> {
                NeoForgeNetworkContext networkContext = new NeoForgeNetworkContext(context);
                packet.handle(networkContext);
            }));
            OELib.LOGGER.info("Registered server network packet: {} (ID: {})", (Object)type.id().getPath(), (Object)type.id());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to register server packet " + packetClass.getSimpleName(), e);
        }
    }

    @Override
    public void registerServerPackets(INetworkManager.PacketRegistration<?> ... packets) {
        for (INetworkManager.PacketRegistration<?> packet : packets) {
            this.registerServerPacketUnchecked(packet.packetClass(), packet.codec());
        }
    }

    private <T extends INetworkPacket<T> & CustomPacketPayload> CustomPacketPayload.Type<T> createPacketType(Class<T> packetClass) {
        try {
            String modId = this.getModIdFromClass(packetClass);
            String className = packetClass.getSimpleName().toLowerCase();
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)modId, (String)className);
            return new CustomPacketPayload.Type(id);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create packet type for " + packetClass.getSimpleName(), e);
        }
    }

    private String getModIdFromClass(Class<?> packetClass) {
        block3: {
            try {
                Object tempInstance = packetClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (tempInstance instanceof SimplePacket) {
                    return ((SimplePacket)tempInstance).getModId();
                }
            }
            catch (Exception e) {
                String packageName = packetClass.getPackage().getName();
                if (!packageName.contains("oelib")) break block3;
                return "oelib";
            }
        }
        return "oelib";
    }

    private <T extends INetworkPacket<T> & CustomPacketPayload> void registerBidirectionalPacketUnchecked(Class<?> packetClass, StreamCodec<? super RegistryFriendlyByteBuf, ?> codec) {
        this.registerBidirectionalPacket(packetClass, codec);
    }

    private <T extends INetworkPacket<T> & CustomPacketPayload> void registerClientPacketUnchecked(Class<?> packetClass, StreamCodec<? super RegistryFriendlyByteBuf, ?> codec) {
        this.registerClientPacket(packetClass, codec);
    }

    private <T extends INetworkPacket<T> & CustomPacketPayload> void registerServerPacketUnchecked(Class<?> packetClass, StreamCodec<? super RegistryFriendlyByteBuf, ?> codec) {
        this.registerServerPacket(packetClass, codec);
    }

    @Override
    public <T extends INetworkPacket<T> & CustomPacketPayload> void sendToPlayer(T packet, ServerPlayer player) {
        if (player == null) {
            OELib.LOGGER.warn("Cannot send packet {}: player is null", (Object)packet.type().id());
            return;
        }
        try {
            PacketDistributor.sendToPlayer((ServerPlayer)player, packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
            OELib.LOGGER.debug("Sent packet {} to player {}", (Object)packet.type().id(), (Object)player.getName().getString());
        }
        catch (Exception e) {
            OELib.LOGGER.error("Failed to send packet {} to player {}: {}", new Object[]{packet.type().id(), player.getName().getString(), e.getMessage(), e});
        }
    }

    @Override
    public <T extends INetworkPacket<T> & CustomPacketPayload> void sendToAll(T packet) {
        try {
            PacketDistributor.sendToAllPlayers(packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
            OELib.LOGGER.debug("Sent packet {} to all players", (Object)packet.type().id());
        }
        catch (Exception e) {
            OELib.LOGGER.error("Failed to send packet {} to all players: {}", new Object[]{packet.type().id(), e.getMessage(), e});
        }
    }

    @Override
    public <T extends INetworkPacket<T> & CustomPacketPayload> void sendToServer(T packet) {
        try {
            PacketDistributor.sendToServer(packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
            OELib.LOGGER.debug("Sent packet {} to server", (Object)packet.type().id());
        }
        catch (Exception e) {
            OELib.LOGGER.error("Failed to send packet {} to server: {}", new Object[]{packet.type().id(), e.getMessage(), e});
        }
    }

    @Override
    public <T extends INetworkPacket<T> & CustomPacketPayload> void sendToPlayerWithChunking(T packet, ServerPlayer player) {
        NetworkPacket annotation;
        if (player == null) {
            OELib.LOGGER.warn("Cannot send packet {}: player is null", (Object)packet.type().id());
            return;
        }
        Class<?> packetClass = packet.getClass();
        if (packetClass.isAnnotationPresent(NetworkPacket.class) && (annotation = packetClass.getAnnotation(NetworkPacket.class)).chunkThreshold() > 0) {
            this.sendWithChunking(packet, (Iterable<ServerPlayer>)Collections.singletonList(player), annotation.chunkThreshold());
            return;
        }
        this.sendToPlayer(packet, player);
    }

    @Override
    public <T extends INetworkPacket<T> & CustomPacketPayload> void sendToAllWithChunking(T packet) {
        MinecraftServer server;
        NetworkPacket annotation;
        Class<?> packetClass = packet.getClass();
        if (packetClass.isAnnotationPresent(NetworkPacket.class) && (annotation = packetClass.getAnnotation(NetworkPacket.class)).chunkThreshold() > 0 && (server = DataManager.getCurrentServer()) != null) {
            List players = server.getPlayerList().getPlayers();
            this.sendWithChunking(packet, players, annotation.chunkThreshold());
            return;
        }
        this.sendToAll(packet);
    }

    private <T extends INetworkPacket<T> & CustomPacketPayload> void sendWithChunking(T packet, Iterable<ServerPlayer> players, int chunkThreshold) {
        try {
            RegistryFriendlyByteBuf tempBuf = new RegistryFriendlyByteBuf(Unpooled.buffer(), null);
            PacketInfo<?> info = registeredPackets.get(packet.type());
            if (info != null) {
                info.codec().encode((Object)tempBuf, packet);
                byte[] packetData = new byte[tempBuf.readableBytes()];
                tempBuf.readBytes(packetData);
                tempBuf.release();
                if (packetData.length <= chunkThreshold) {
                    for (ServerPlayer player : players) {
                        this.sendToPlayer(packet, player);
                    }
                    OELib.LOGGER.debug("Sent packet {} without chunking ({} bytes)", (Object)packet.type().id(), (Object)packetData.length);
                } else {
                    this.sendChunkedPacket(packetData, packet.getClass().getName(), players, chunkThreshold);
                }
            } else {
                OELib.LOGGER.error("No codec found for packet type: {}", (Object)packet.type().id());
            }
        }
        catch (Exception e) {
            OELib.LOGGER.error("Failed to send packet {} with chunking: {}", new Object[]{packet.type().id(), e.getMessage(), e});
        }
    }

    private void sendChunkedPacket(byte[] data, String packetClassName, Iterable<ServerPlayer> players, int chunkSize) {
        try {
            UUID sessionId = UUID.randomUUID();
            int totalChunks = (int)Math.ceil((double)data.length / (double)chunkSize);
            OELib.LOGGER.info("Splitting {} packet into {} chunks for session {} ({} bytes total)", new Object[]{packetClassName, totalChunks, sessionId, data.length});
            for (int i = 0; i < totalChunks; ++i) {
                int start = i * chunkSize;
                int end = Math.min(start + chunkSize, data.length);
                int currentChunkSize = end - start;
                byte[] chunkData = new byte[currentChunkSize];
                System.arraycopy(data, start, chunkData, 0, currentChunkSize);
                DataSyncChunkPacket chunk = new DataSyncChunkPacket(sessionId, i, totalChunks, packetClassName, chunkData);
                for (ServerPlayer player : players) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)chunk, (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                OELib.LOGGER.debug("Sent chunk {}/{} ({} bytes) for {} session {}", new Object[]{i + 1, totalChunks, currentChunkSize, packetClassName, sessionId});
            }
        }
        catch (Exception e) {
            OELib.LOGGER.error("Failed to send chunked packet {}: {}", new Object[]{packetClassName, e.getMessage(), e});
        }
    }

    public static int getRegisteredPacketCount() {
        return registeredPackets.size();
    }

    public static Set<CustomPacketPayload.Type<?>> getRegisteredPacketTypes() {
        return new HashSet(registeredPackets.keySet());
    }

    private static void registerBuiltinPackets() {
        instance.registerBidirectionalPacket(DataSyncChunkPacket.class, DataSyncChunkPacket.STREAM_CODEC);
        OELib.LOGGER.info("Registered builtin data sync packets");
    }

    private record PacketInfo<T extends INetworkPacket<T> & CustomPacketPayload>(CustomPacketPayload.Type<T> type, StreamCodec<? super RegistryFriendlyByteBuf, T> codec) {
    }
}

