/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oelib.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mafuyu404.oelib.OELib;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;

public class CodecUtils {
    private static final Map<Class<?>, Codec<?>> codecCache = new ConcurrentHashMap();

    public static <T> Optional<String> encodeToJson(Class<T> dataClass, Map<ResourceLocation, T> data) {
        return CodecUtils.executeWithExceptionHandling(dataClass, "encoding", () -> {
            Codec mapCodec = CodecUtils.createMapCodec(dataClass);
            DataResult result = mapCodec.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)data);
            return CodecUtils.handleDataResult(dataClass, "encode", result).map(JsonElement::toString);
        });
    }

    public static <T> Optional<Map<ResourceLocation, T>> decodeFromJson(Class<T> dataClass, String jsonData) {
        return CodecUtils.executeWithExceptionHandling(dataClass, "decoding", () -> {
            JsonElement jsonElement = JsonParser.parseString((String)jsonData);
            Codec mapCodec = CodecUtils.createMapCodec(dataClass);
            DataResult result = mapCodec.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement);
            return CodecUtils.handleDataResult(dataClass, "decode", result);
        });
    }

    public static <T> Optional<T> decodeSingle(Class<T> dataClass, JsonElement jsonElement) {
        return CodecUtils.executeWithExceptionHandling(dataClass, "decoding", () -> {
            Codec codec = CodecUtils.getCodec(dataClass);
            DataResult result = codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement);
            return CodecUtils.handleDataResult(dataClass, "decode", result);
        });
    }

    private static <T, R> Optional<R> executeWithExceptionHandling(Class<T> dataClass, String operationType, Supplier<Optional<R>> action) {
        try {
            return action.get();
        }
        catch (Exception e) {
            OELib.LOGGER.error("Exception during {} {} for {}: {}", new Object[]{dataClass.getSimpleName(), operationType, e.getMessage(), e});
            return Optional.empty();
        }
    }

    private static <T> Optional<T> handleDataResult(Class<?> dataClass, String operation, DataResult<T> result) {
        if (result.error().isPresent()) {
            DataResult.Error error = (DataResult.Error)result.error().get();
            OELib.LOGGER.error("Failed to {} {} data: {}", new Object[]{operation, dataClass.getSimpleName(), error.message()});
            return Optional.empty();
        }
        return result.result();
    }

    private static <T> Codec<Map<ResourceLocation, T>> createMapCodec(Class<T> dataClass) {
        Codec<T> codec = CodecUtils.getCodec(dataClass);
        return Codec.unboundedMap((Codec)ResourceLocation.CODEC, codec);
    }

    @Deprecated
    public static <T> Codec<T> getCodec(Class<T> dataClass) {
        return codecCache.computeIfAbsent(dataClass, cls -> {
            try {
                Field codecField = cls.getDeclaredField("CODEC");
                codecField.setAccessible(true);
                return (Codec)codecField.get(null);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get CODEC field from " + cls.getSimpleName() + ". Make sure the class has a public static final CODEC field.", e);
            }
        });
    }

    public static <T> void registerCodec(Class<T> dataClass, Codec<T> codec) {
        codecCache.put(dataClass, codec);
    }
}

