/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.demonsemeraldtools.client.fluid;

import javax.annotation.Nullable;
import net.mcreator.demonsemeraldtools.init.DemonsEmeraldToolsModFluidTypes;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.fog.FogData;
import net.minecraft.client.renderer.fog.environment.FogEnvironment;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.fluids.FluidType;

@EventBusSubscriber(value={Dist.CLIENT})
public class EmeraldgooFluidExtension {
    @SubscribeEvent
    public static void registerFluidTypeExtensions(RegisterClientExtensionsEvent event) {
        event.registerFluidType(new IClientFluidTypeExtensions(){
            private static final ResourceLocation STILL_TEXTURE = ResourceLocation.parse((String)"demons_emerald_tools:block/emeraldpainting");
            private static final ResourceLocation FLOWING_TEXTURE = ResourceLocation.parse((String)"demons_emerald_tools:block/emeraldpainting");
            private static final ResourceLocation RENDER_OVERLAY_TEXTURE = ResourceLocation.parse((String)"demons_emerald_tools:textures/empainting.png");

            public ResourceLocation getStillTexture() {
                return STILL_TEXTURE;
            }

            public ResourceLocation getFlowingTexture() {
                return FLOWING_TEXTURE;
            }

            public ResourceLocation getRenderOverlayTexture(Minecraft minecraft) {
                return RENDER_OVERLAY_TEXTURE;
            }

            public void modifyFogRender(Camera camera, @Nullable FogEnvironment environment, float renderDistance, float partialTick, FogData fogData) {
                float nearDistance = fogData.environmentalStart;
                float farDistance = fogData.environmentalEnd;
                Entity entity = camera.getEntity();
                Level world = entity.level();
                fogData.environmentalStart = 0.0f;
                fogData.environmentalEnd = Math.min(48.0f, renderDistance);
            }
        }, new FluidType[]{(FluidType)DemonsEmeraldToolsModFluidTypes.EMERALDGOO_TYPE.get()});
    }
}

