/*
 * Decompiled with CFR 0.152.
 */
package main.walksy.lib.core.callback;

import java.util.function.Consumer;
import main.walksy.lib.core.utils.log.WalksyLibLogger;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWDropCallback;
import org.lwjgl.glfw.GLFWDropCallbackI;

public class WindowDropCallback {
    private static Consumer<String> dropCallback;

    public static void register(long windowHandle, Consumer<String> callback) {
        dropCallback = callback;
        GLFWDropCallback glfwDropCallback = new GLFWDropCallback(){

            public void invoke(long window, int count, long names) {
                for (int i = 0; i < count; ++i) {
                    String path = 1.getName((long)names, (int)i);
                    WindowDropCallback.onFileDrop(path);
                }
            }
        };
        GLFWDropCallback rtrn = GLFW.glfwSetDropCallback((long)windowHandle, (GLFWDropCallbackI)glfwDropCallback);
        WalksyLibLogger.info("Attempted to register GLFW Drop Callback: " + String.valueOf(rtrn));
    }

    public static void unregister(long windowHandle) {
        dropCallback = null;
        GLFWDropCallback rtrn = GLFW.glfwSetDropCallback((long)windowHandle, null);
        WalksyLibLogger.info("Attempted to un-register GLFW Drop Callback: " + String.valueOf(rtrn));
    }

    private static void onFileDrop(String path) {
        if (dropCallback != null) {
            dropCallback.accept(path);
        }
    }
}

