/*
 * Decompiled with CFR 0.152.
 */
package main.walksy.lib.core.config.impl;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import main.walksy.lib.core.config.Config;
import main.walksy.lib.core.config.local.Category;
import main.walksy.lib.core.config.local.builders.LocalConfigBuilder;
import main.walksy.lib.core.config.serialization.SerializableCategory;
import main.walksy.lib.core.manager.WalksyLibConfigManager;
import main.walksy.lib.core.utils.log.WalksyLibLogger;

public record LocalConfig(String name, Path path, List<Category> categories, Runnable onSave) implements Config
{
    @Override
    public void load() {
        List loadedCategories;
        Path path = this.path();
        if (!Files.exists(path, new LinkOption[0])) {
            this.save();
            return;
        }
        try {
            String json = Files.readString(path);
            Type type = new TypeToken<List<SerializableCategory>>(){}.getType();
            loadedCategories = (List)WalksyLibConfigManager.GSON.fromJson(json, type);
        }
        catch (JsonParseException | IOException e) {
            WalksyLibLogger.err("Failed to read or parse config from " + String.valueOf(path) + ": " + e.getMessage());
            return;
        }
        for (Category existingCategory : this.categories()) {
            loadedCategories.stream().filter(serialized -> serialized.name.equals(existingCategory.name())).findFirst().ifPresent(serialized -> WalksyLibConfigManager.applyCategoryValues(existingCategory, serialized));
        }
    }

    @Override
    public void save() {
        Path path = this.path();
        ArrayList<SerializableCategory> serializedCategories = new ArrayList<SerializableCategory>();
        for (Category category : this.categories()) {
            serializedCategories.add(WalksyLibConfigManager.serializeCategory(category));
        }
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            String json = WalksyLibConfigManager.GSON.toJson(serializedCategories);
            Files.writeString(path, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            WalksyLibLogger.err("Failed to save config to " + String.valueOf(path) + ": " + e.getMessage());
        }
    }

    public void runSave() {
        if (this.onSave != null) {
            this.onSave.run();
        }
    }

    public static LocalConfigBuilder createBuilder(String name) {
        return new LocalConfigBuilder(name);
    }
}

