/*
 * Decompiled with CFR 0.152.
 */
package main.walksy.lib.core.config.local;

import java.awt.Color;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import main.walksy.lib.core.config.impl.LocalConfig;
import main.walksy.lib.core.config.local.OptionDescription;
import main.walksy.lib.core.config.local.options.BooleanOption;
import main.walksy.lib.core.config.local.options.groups.OptionGroup;
import main.walksy.lib.core.config.local.options.type.PixelGridAnimation;
import main.walksy.lib.core.config.local.options.type.WalksyLibColor;
import main.walksy.lib.core.gui.impl.WalksyLibConfigScreen;
import main.walksy.lib.core.gui.widgets.BooleanWidget;
import main.walksy.lib.core.gui.widgets.ButtonOptionWidget;
import main.walksy.lib.core.gui.widgets.ColorWidget;
import main.walksy.lib.core.gui.widgets.EnumOptionWidget;
import main.walksy.lib.core.gui.widgets.NumericalWidget;
import main.walksy.lib.core.gui.widgets.OptionWidget;
import main.walksy.lib.core.gui.widgets.PixelGridAnimationWidget;
import main.walksy.lib.core.gui.widgets.SpriteOptionWidget;
import main.walksy.lib.core.gui.widgets.StringListOptionWidget;
import main.walksy.lib.core.gui.widgets.StringOptionWidget;
import main.walksy.lib.core.utils.IdentifierWrapper;
import main.walksy.lib.core.utils.SearchUtils;
import main.walksy.lib.core.utils.log.InternalLog;
import main.walksy.lib.core.utils.log.WalksyLibLogger;
import net.minecraft.class_2561;
import net.minecraft.class_7919;

public class Option<T> {
    private final String name;
    private final Supplier<T> getter;
    private final Consumer<T> setter;
    private final Class<T> type;
    private final T min;
    private final T max;
    private final T increment;
    private OptionDescription description;
    private final T defaultValue;
    private final Supplier<Boolean> availability;
    private final String availabilityHelper;
    private T prevValue;
    private final Runnable onChange;
    public T screenInstanceValue = null;
    private final BooleanOption.Warning warning;
    private String searchQ = "";

    public Option(String name, OptionDescription description, Supplier<T> getter, Consumer<T> setter, Supplier<Boolean> availability, String availabilityHelper, Class<T> type, T defaultValue, BooleanOption.Warning warning, Runnable onChange) {
        this(name, description, (Supplier<Object>)getter, (Consumer<Object>)setter, availability, availabilityHelper, (Class<Object>)type, null, null, null, defaultValue, warning, onChange);
    }

    public Option(String name, OptionDescription description, Supplier<T> getter, Consumer<T> setter, Supplier<Boolean> availability, String availabilityHelper, Class<T> type, T defaultValue, Runnable onChange) {
        this(name, description, (Supplier<Object>)getter, (Consumer<Object>)setter, availability, availabilityHelper, (Class<Object>)type, null, null, null, defaultValue, null, onChange);
    }

    public Option(String name, OptionDescription description, Supplier<T> getter, Consumer<T> setter, Supplier<Boolean> availability, String availabilityHelper, Class<T> type, T min, T max, T increment, T defaultValue, BooleanOption.Warning warning, Runnable onChange) {
        this.name = name;
        this.description = description;
        this.getter = getter;
        this.setter = setter;
        this.availability = availability;
        this.availabilityHelper = availabilityHelper;
        this.type = type;
        this.min = min;
        this.max = max;
        this.increment = increment;
        this.defaultValue = getter.get() instanceof PixelGridAnimation ? ((PixelGridAnimation)defaultValue).copy() : (getter.get() instanceof WalksyLibColor ? ((WalksyLibColor)defaultValue).copy() : defaultValue);
        this.prevValue = null;
        this.onChange = onChange;
        this.warning = warning;
    }

    public String getName() {
        return this.name;
    }

    private Supplier<T> getGetter() {
        return this.getter;
    }

    private Consumer<T> getSetter() {
        return this.setter;
    }

    public Class<T> getType() {
        return this.type;
    }

    public T getMin() {
        return this.min;
    }

    public T getMax() {
        return this.max;
    }

    public T getIncrement() {
        return this.increment;
    }

    public OptionDescription getDescription() {
        return this.description;
    }

    public String getAvailabilityHelper() {
        return this.availabilityHelper;
    }

    public T getValue() {
        return this.getter.get();
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public boolean screenInstanceCheck() {
        return Objects.equals(this.screenInstanceValue, this.getValue());
    }

    public void setScreenInstance() {
        T t = this.getValue();
        if (t instanceof PixelGridAnimation) {
            PixelGridAnimation animation = (PixelGridAnimation)t;
            this.screenInstanceValue = animation.copy();
        } else {
            t = this.getValue();
            if (t instanceof WalksyLibColor) {
                WalksyLibColor color = (WalksyLibColor)t;
                this.screenInstanceValue = color.copy();
            } else {
                this.screenInstanceValue = this.getter.get();
            }
        }
    }

    public void undo() {
        if (this.setter == null) {
            return;
        }
        this.setter.accept(this.screenInstanceValue);
    }

    public void setValue(Object value) {
        if (this.type.isInstance(value)) {
            if (this.setter != null) {
                if (!this.getter.get().equals(value)) {
                    this.runChange();
                }
                this.setter.accept(value);
            }
        } else {
            throw new IllegalArgumentException("Invalid value type: " + value.getClass().getName());
        }
    }

    public boolean canReset() {
        return this.getValue() != this.defaultValue;
    }

    public boolean isAvailable() {
        return this.availability.get();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setPrev(LocalConfig config) {
        if (Objects.equals(this.getValue(), this.screenInstanceValue)) {
            return;
        }
        T oldVal = this.prevValue = this.screenInstanceValue;
        T newVal = this.getValue();
        if (oldVal instanceof WalksyLibColor) {
            WalksyLibColor oldColor = (WalksyLibColor)oldVal;
            if (newVal instanceof WalksyLibColor) {
                WalksyLibColor newColor = (WalksyLibColor)newVal;
                if (oldColor.isRainbow() != newColor.isRainbow()) {
                    this.logField(config, this.getName() + "'s Rainbow", oldColor.isRainbow(), newColor.isRainbow());
                }
                if (oldColor.getRainbowSpeed() != newColor.getRainbowSpeed()) {
                    this.logField(config, this.getName() + "'s Rainbow Speed", oldColor.getRainbowSpeed(), newColor.getRainbowSpeed());
                }
                if (oldColor.isPulse() != newColor.isPulse()) {
                    this.logField(config, this.getName() + "'s Pulse", oldColor.isPulse(), newColor.isPulse());
                }
                if (oldColor.getPulseSpeed() != newColor.getPulseSpeed()) {
                    this.logField(config, this.getName() + "'s Pulse Speed", oldColor.getPulseSpeed(), newColor.getPulseSpeed());
                }
                if (Float.compare(oldColor.getSaturation(), newColor.getSaturation()) != 0) {
                    this.logField(config, this.getName() + "'s Saturation", Float.valueOf(oldColor.getSaturation()), Float.valueOf(newColor.getSaturation()));
                }
                if (Float.compare(oldColor.getBrightness(), newColor.getBrightness()) == 0) return;
                this.logField(config, this.getName() + "'s Brightness", Float.valueOf(oldColor.getBrightness()), Float.valueOf(newColor.getBrightness()));
                return;
            }
        }
        if (oldVal instanceof PixelGridAnimation) {
            PixelGridAnimation oldAnim = (PixelGridAnimation)oldVal;
            if (newVal instanceof PixelGridAnimation) {
                PixelGridAnimation newAnim = (PixelGridAnimation)newVal;
                if (oldAnim.getAnimationSpeed() != newAnim.getAnimationSpeed()) {
                    this.logField(config, this.getName() + "'s Speed", oldAnim.getAnimationSpeed(), newAnim.getAnimationSpeed());
                }
                if (Double.compare(oldAnim.getOffsetX(), newAnim.getOffsetX()) != 0) {
                    this.logField(config, this.getName() + "'s X Pos", oldAnim.getOffsetX(), newAnim.getOffsetX());
                }
                if (Double.compare(oldAnim.getOffsetY(), newAnim.getOffsetY()) == 0) return;
                this.logField(config, this.getName() + "'s Y Pos", oldAnim.getOffsetY(), newAnim.getOffsetY());
                return;
            }
        }
        this.logField(config, this.getName(), oldVal, newVal);
    }

    private String formatValue(Object value) {
        String str;
        if (value == null) {
            return "Not Set";
        }
        if (value instanceof Float) {
            Float f = (Float)value;
            str = String.format("%.3f", f);
        } else if (value instanceof Double) {
            Double d = (Double)value;
            str = String.format("%.3f", d);
        } else {
            str = value.toString();
        }
        return str;
    }

    private <V> void logField(LocalConfig config, String name, V oldVal, V newVal) {
        String configName = config.name();
        InternalLog.ToolTip toolTip = null;
        if (this.warning != null) {
            toolTip = new InternalLog.ToolTip(class_7919.method_47407((class_2561)class_2561.method_30163((String)("Option has warning: " + this.warning.message))), Color.RED.getRGB());
        }
        String time = LocalTime.now().format(DateTimeFormatter.ofPattern("HH:mm:ss"));
        WalksyLibLogger.log(InternalLog.of("[" + time + "]: [" + configName + "] -> [" + name + "], [" + String.valueOf(oldVal) + "] to [" + String.valueOf(newVal) + "]", toolTip));
    }

    public void reset() {
        if (this.getType() == Runnable.class) {
            return;
        }
        if (this.getValue() instanceof PixelGridAnimation) {
            this.setter.accept(((PixelGridAnimation)this.defaultValue).copy());
        } else {
            T t = this.getValue();
            if (t instanceof WalksyLibColor) {
                WalksyLibColor c = (WalksyLibColor)t;
                this.setter.accept(((WalksyLibColor)this.defaultValue).copy());
            } else {
                this.setter.accept(this.defaultValue);
            }
        }
    }

    public Option<T> description(OptionDescription description) {
        this.description = description;
        return this;
    }

    public boolean hasChanged() {
        T value = this.getValue();
        T defaultValue = this.getDefaultValue();
        if (value == null || defaultValue == null) {
            return value != defaultValue;
        }
        return !Objects.equals(value, defaultValue);
    }

    public T getPrevValue() {
        return this.prevValue;
    }

    public boolean searched() {
        if (this.searchQ.isEmpty()) {
            return true;
        }
        String[] queryWords = this.searchQ.toLowerCase().trim().split("\\s+");
        String[] nameWords = this.getName().toLowerCase().trim().split("\\s+");
        block0: for (String qWord : queryWords) {
            for (String numWord : nameWords) {
                if (numWord.contains(qWord) || numWord.startsWith(qWord) || SearchUtils.levenshteinDistance(numWord, qWord) <= 2) continue block0;
            }
            return false;
        }
        return true;
    }

    public void updateSearchQ(String searchQ) {
        this.searchQ = searchQ;
    }

    public void runChange() {
        if (this.onChange != null) {
            this.onChange.run();
        }
    }

    public OptionWidget createWidget(OptionGroup parent, WalksyLibConfigScreen screen, int x, int y, int width, int height) {
        if (this.type == Boolean.class) {
            return new BooleanWidget(parent, screen, x, y, width, height, this, this.warning);
        }
        if (this.type == Integer.class) {
            return new NumericalWidget(parent, screen, x, y, width, height, this);
        }
        if (this.type == Double.class) {
            return new NumericalWidget(parent, screen, x, y, width, height, this);
        }
        if (this.type == Float.class) {
            return new NumericalWidget(parent, screen, x, y, width, height, this);
        }
        if (this.type == Color.class || this.type == WalksyLibColor.class) {
            return new ColorWidget(parent, screen, x, y, width, height, this);
        }
        if (this.type == PixelGridAnimation.class) {
            return new PixelGridAnimationWidget(parent, screen, x, y, width, height, this);
        }
        if (this.type == List.class) {
            return new StringListOptionWidget(parent, screen, x, y, width, height, this);
        }
        if (this.type == Runnable.class) {
            return new ButtonOptionWidget(parent, screen, x, y, width, height, this);
        }
        if (this.type == IdentifierWrapper.class) {
            return new SpriteOptionWidget(parent, screen, x, y, width, height, this);
        }
        if (this.type == String.class) {
            return new StringOptionWidget(parent, screen, x, y, width, height, this);
        }
        if (Enum.class.isAssignableFrom(this.type)) {
            Option enumOption = this;
            Class<T> enumClass = this.type;
            return new EnumOptionWidget(parent, screen, x, y, width, height, enumOption);
        }
        throw new UnsupportedOperationException("Unsupported option type: " + String.valueOf(this.type));
    }
}

