/*
 * Decompiled with CFR 0.152.
 */
package main.walksy.lib.core.config.local;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_332;

public class OptionDescription {
    private final OptionType type;
    private final BiConsumer<class_332, OptionPanel> renderConsumer;
    private final Supplier<String> textSupplier;

    private OptionDescription(OptionType type, BiConsumer<class_332, OptionPanel> renderConsumer, Supplier<String> textSupplier) {
        this.type = type;
        this.renderConsumer = renderConsumer;
        this.textSupplier = textSupplier;
    }

    public static OptionDescription ofRender2D(BiConsumer<class_332, OptionPanel> renderConsumer) {
        return new OptionDescription(OptionType.RENDER, renderConsumer, null);
    }

    public static OptionDescription ofOrderedString(Supplier<String> textSupplier) {
        return new OptionDescription(OptionType.TEXT, null, textSupplier);
    }

    public OptionType getType() {
        return this.type;
    }

    public BiConsumer<class_332, OptionPanel> getRenderConsumer() {
        return this.renderConsumer;
    }

    public Supplier<String> getStringSupplier() {
        return this.textSupplier;
    }

    public static enum OptionType {
        RENDER,
        TEXT;

    }

    public record OptionPanel(int x, int y, int width, int height) {
        public int endX() {
            return this.x + this.width;
        }

        public int endY() {
            return this.y + this.height;
        }
    }
}

