/*
 * Decompiled with CFR 0.152.
 */
package main.walksy.lib.core.config.local.builders;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import main.walksy.lib.core.config.impl.LocalConfig;
import main.walksy.lib.core.config.local.Category;

public class LocalConfigBuilder {
    private final String configName;
    private final List<Category> categories = new ArrayList<Category>();
    private Path path;
    private Runnable onSave;

    public LocalConfigBuilder(String configName) {
        this.configName = configName;
    }

    public LocalConfigBuilder path(Path path) {
        this.path = path;
        return this;
    }

    public LocalConfigBuilder category(Category categoryBuilder) {
        this.categories.add(categoryBuilder);
        return this;
    }

    public LocalConfigBuilder onSave(Runnable onSave) {
        this.onSave = onSave;
        return this;
    }

    public LocalConfig build() {
        if (this.path == null) {
            throw new IllegalStateException("[WalksyLib] LocalConfigBuilder error: Missing required .path()!\nYou must call .path(Path) before build().\nExample:\n    new LocalConfigBuilder(\"example\")\n        .path(FabricLoader.getInstance().getConfigDir().resolve(\"example.json\"))\n        .build();\n");
        }
        return new LocalConfig(this.configName, this.path, this.categories, this.onSave);
    }
}

