/*
 * Decompiled with CFR 0.152.
 */
package main.walksy.lib.core.config.local.options.type;

import java.awt.Point;
import java.util.Arrays;
import java.util.function.Supplier;
import main.walksy.lib.core.renderer.Renderer2D;
import net.minecraft.class_332;

public class PixelGrid {
    private final int width;
    private final int height;
    private boolean[][] pixels;

    public PixelGrid(int width, int height, boolean[][] pixels) {
        this.width = width;
        this.height = height;
        this.pixels = new boolean[height][width];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                this.pixels[y][x] = y < pixels.length && x < pixels[y].length && pixels[y][x];
            }
        }
    }

    public void render(class_332 context, Supplier<Point> position, boolean blend) {
        if (position == null || position.get().x == -1 && position.get().y == -1) {
            return;
        }
        Renderer2D.renderGridTexture(context, this, position.get().x, position.get().y, 1, 0, blend);
    }

    public void render(class_332 context, float x, float y, boolean blend) {
        Renderer2D.renderGridTexture(context, this, x, y, 1, 0, blend);
    }

    public boolean getPixel(int x, int y) {
        return this.pixels[y][x];
    }

    public void setPixel(int x, int y, boolean val) {
        this.pixels[y][x] = val;
    }

    public void setPixels(boolean[][] pixels) {
        this.pixels = pixels;
    }

    public boolean[][] getPixels() {
        return this.pixels;
    }

    public PixelGrid copy() {
        return new PixelGrid(this.width, this.height, this.pixels);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public static Builder create(int width, int height) {
        return new Builder(width, height);
    }

    public static Builder create() {
        return PixelGrid.create(15, 15);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PixelGrid)) {
            return false;
        }
        PixelGrid other = (PixelGrid)obj;
        if (this.width != other.width || this.height != other.height) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.pixels, (Object[])other.pixels);
    }

    public static class Builder {
        private final int width;
        private final int height;
        private final boolean[][] pixels;

        public Builder(int width, int height) {
            this.width = width;
            this.height = height;
            this.pixels = new boolean[height][width];
        }

        public Builder set(int x, int y) {
            if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
                this.pixels[y][x] = true;
            }
            return this;
        }

        public PixelGrid build() {
            return new PixelGrid(this.width, this.height, this.pixels);
        }
    }
}

