/*
 * Decompiled with CFR 0.152.
 */
package main.walksy.lib.core.config.local.options.type;

import java.util.ArrayList;
import java.util.List;
import main.walksy.lib.core.config.local.options.type.PixelGrid;
import net.minecraft.class_241;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;

public class PixelGridAnimation {
    private final List<PixelGrid> frames = new ArrayList<PixelGrid>();
    private int currentFrame = 0;
    private int tickCounter = 0;
    private int animationSpeed = 10;
    private double offsetX = 0.0;
    private double offsetY = 0.0;
    private float size = 1.0f;
    private boolean hasPlayedOnce = false;

    public PixelGridAnimation(PixelGrid ... grids) {
        ArrayList<PixelGrid> grids1 = new ArrayList<PixelGrid>(List.of(grids));
        if (grids1.isEmpty()) {
            grids1.add(PixelGrid.create().build());
        }
        this.frames.addAll(grids1);
    }

    public PixelGridAnimation(List<PixelGrid> grids) {
        this.frames.addAll(grids);
    }

    public PixelGridAnimation(PixelGridAnimation original, PixelGrid replacement, int index) {
        for (int i = 0; i < original.frames.size(); ++i) {
            this.frames.add(i == index - 1 ? replacement : original.frames.get(i));
        }
        this.offsetX = original.offsetX;
        this.offsetY = original.offsetY;
        this.size = original.size;
    }

    public static PixelGridAnimation replace(PixelGridAnimation original, PixelGrid replacement, int index) {
        PixelGridAnimation result = new PixelGridAnimation(original, replacement, index);
        result.setCurrentFrame(original.currentFrame);
        result.setAnimationSpeed(original.animationSpeed);
        return result;
    }

    public void resetAnimation() {
        this.currentFrame = 0;
        this.tickCounter = 0;
        this.hasPlayedOnce = false;
    }

    public void render(class_332 context, boolean blend) {
        class_241 pos = this.getAbsolutePosition();
        this.render(context, pos.field_1343, pos.field_1342, blend);
    }

    public void render(class_332 context, float x, float y, boolean blend) {
        PixelGrid frame = this.getCurrentFrame();
        if (frame != null) {
            context.method_51448().method_22903();
            context.method_51448().method_22905(this.size, this.size, 1.0f);
            frame.render(context, x / this.size, y / this.size, blend);
            context.method_51448().method_22909();
        }
    }

    public void tick() {
        if (this.frames.isEmpty() || this.animationSpeed <= 0) {
            return;
        }
        ++this.tickCounter;
        int frameDelay = Math.max(1, 21 - this.animationSpeed);
        if (this.tickCounter >= frameDelay) {
            this.tickCounter = 0;
            int prevFrame = this.currentFrame;
            this.currentFrame = (this.currentFrame + 1) % this.frames.size();
            if (this.currentFrame == 0 && prevFrame == this.frames.size() - 1) {
                this.hasPlayedOnce = true;
            }
        }
    }

    public boolean hasPlayedOnce() {
        return this.hasPlayedOnce;
    }

    public void setAnimationSpeed(int speed) {
        this.animationSpeed = class_3532.method_15340((int)speed, (int)1, (int)100);
    }

    public int getAnimationSpeed() {
        return this.animationSpeed;
    }

    public PixelGrid getCurrentFrame() {
        return this.frames.isEmpty() ? null : this.frames.get(this.currentFrame);
    }

    public List<PixelGrid> getFrames() {
        return this.frames;
    }

    public PixelGrid getFrame(int index) {
        int adjusted = index - 1;
        if (adjusted < 0 || adjusted >= this.frames.size()) {
            return null;
        }
        return this.frames.get(adjusted);
    }

    public void setFrame(int index, PixelGrid grid) {
        this.frames.set(index - 1, grid);
    }

    public void addFrame(PixelGrid grid) {
        this.frames.add(grid);
    }

    public void setCurrentFrame(int index) {
        this.currentFrame = class_3532.method_15340((int)index, (int)0, (int)(this.frames.size() - 1));
    }

    public class_241 getAbsolutePosition() {
        class_310 client = class_310.method_1551();
        if (client == null || client.method_22683() == null) {
            return new class_241(0.0f, 0.0f);
        }
        int windowWidth = client.method_22683().method_4486();
        int windowHeight = client.method_22683().method_4502();
        PixelGrid frame = this.getCurrentFrame();
        int frameW = frame == null ? 0 : frame.getWidth();
        int frameH = frame == null ? 0 : frame.getHeight();
        int renderedW = Math.round((float)frameW * this.size);
        int renderedH = Math.round((float)frameH * this.size);
        int baseX = (windowWidth - renderedW) / 2;
        int baseY = (windowHeight - renderedH) / 2;
        double rawX = (double)baseX + this.offsetX;
        double rawY = (double)baseY + this.offsetY;
        float x = (float)((double)Math.round(rawX * 2.0) / 2.0);
        float y = (float)((double)Math.round(rawY * 2.0) / 2.0);
        return new class_241(x, y);
    }

    public PixelGridAnimation offset(double offsetX, double offsetY) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        return this;
    }

    public void setOffset(double offsetX, double offsetY) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public void addOffset(double dx, double dy) {
        this.offsetX += dx;
        this.offsetY += dy;
    }

    public double getOffsetX() {
        return this.offsetX;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public PixelGridAnimation animationSpeed(int speed) {
        this.animationSpeed = speed;
        return this;
    }

    public void setSize(float size) {
        this.size = class_3532.method_15363((float)size, (float)0.1f, (float)10.0f);
    }

    public float getSize() {
        return this.size;
    }

    public PixelGridAnimation copy() {
        List<PixelGrid> copiedFrames = this.frames.stream().map(PixelGrid::copy).toList();
        PixelGridAnimation copy = new PixelGridAnimation(copiedFrames);
        copy.currentFrame = this.currentFrame;
        copy.animationSpeed = this.animationSpeed;
        copy.offsetX = this.offsetX;
        copy.offsetY = this.offsetY;
        copy.size = this.size;
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PixelGridAnimation)) {
            return false;
        }
        PixelGridAnimation other = (PixelGridAnimation)obj;
        if (this.animationSpeed != other.animationSpeed) {
            return false;
        }
        if (this.offsetX != other.offsetX || this.offsetY != other.offsetY) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        if (this.frames.size() != other.frames.size()) {
            return false;
        }
        for (int i = 0; i < this.frames.size(); ++i) {
            if (this.frames.get(i).equals(other.frames.get(i))) continue;
            return false;
        }
        return true;
    }
}

