/*
 * Decompiled with CFR 0.152.
 */
package main.walksy.lib.core.config.local.options.type;

public class WalksyLibColor {
    private int value;
    private float hue = 0.0f;
    private float saturation;
    private float brightness;
    private boolean rainbow = false;
    private int rainbowSpeed = 5;
    private int pulseSpeed = 5;
    private boolean pulse = false;
    private float pulseTime = 0.0f;

    public WalksyLibColor(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public WalksyLibColor(int r, int g, int b, int a) {
        this.value = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
        float[] hsb = WalksyLibColor.RGBtoHSB(r, g, b, null);
        this.hue = hsb[0];
        this.saturation = hsb[1];
        this.brightness = hsb[2];
    }

    public WalksyLibColor(int rgb) {
        this.value = 0xFF000000 | rgb;
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        float[] hsb = WalksyLibColor.RGBtoHSB(r, g, b, null);
        this.hue = hsb[0];
        this.saturation = hsb[1];
        this.brightness = hsb[2];
    }

    public boolean isRainbow() {
        return this.rainbow;
    }

    public void setHue(float hue) {
        this.hue = Math.max(0.0f, Math.min(1.0f, hue));
    }

    public float getHue() {
        return this.hue;
    }

    public void setSaturation(float saturation) {
        this.saturation = Math.max(0.0f, Math.min(1.0f, saturation));
    }

    public float getSaturation() {
        return this.saturation;
    }

    public void setBrightness(float brightness) {
        this.brightness = Math.max(0.0f, Math.min(1.0f, brightness));
    }

    public float getBrightness() {
        return this.brightness;
    }

    public int getRainbowSpeed() {
        return this.rainbowSpeed;
    }

    public void setRainbow(boolean rainbow) {
        this.rainbow = rainbow;
    }

    public void setRainbowSpeed(int rainbowSpeed) {
        this.rainbowSpeed = rainbowSpeed;
    }

    public int getPulseSpeed() {
        return this.pulseSpeed;
    }

    public void setPulseSpeed(int pulseSpeed) {
        this.pulseSpeed = pulseSpeed;
    }

    public boolean isPulse() {
        return this.pulse;
    }

    public void setPulse(boolean pulse) {
        this.pulse = pulse;
    }

    public void setAlpha(int alpha) {
        WalksyLibColor newColor = new WalksyLibColor(this.getRed(), this.getGreen(), this.getBlue(), alpha);
        this.value = newColor.getRGB();
    }

    public void resetHSB() {
        float[] hsb = WalksyLibColor.RGBtoHSB(this.getRed(), this.getGreen(), this.getBlue(), null);
        this.hue = hsb[0];
        this.saturation = hsb[1];
        this.brightness = hsb[2];
    }

    public void resetAdditions() {
        this.pulse = false;
        this.rainbow = false;
        this.rainbowSpeed = 5;
        this.pulseSpeed = 5;
    }

    public Additions getAdditions() {
        return new Additions(this.hue, this.saturation, this.brightness, this.rainbow, this.rainbowSpeed, this.pulse, this.pulseSpeed);
    }

    public void setAdditions(Additions additions) {
        this.setHue(additions.hue);
        this.setSaturation(additions.saturation);
        this.setBrightness(additions.brightness);
        this.setRainbow(additions.rainbow);
        this.setRainbowSpeed(additions.rainbowSpeed);
        this.setPulse(additions.pulse);
        this.setPulseSpeed(additions.pulseSpeed);
    }

    public void tick() {
        if (this.rainbow) {
            float speed = (float)this.rainbowSpeed / 1000.0f;
            this.hue += speed;
            if (this.hue > 1.0f) {
                this.hue = 0.0f;
            }
            WalksyLibColor newColor = WalksyLibColor.getHSBColor(this.hue, this.saturation, this.brightness);
            WalksyLibColor newColorAlpha = new WalksyLibColor(newColor.getRed(), newColor.getGreen(), newColor.getBlue(), this.getAlpha());
            this.value = newColorAlpha.getRGB();
        }
        this.handlePulse();
    }

    private void handlePulse() {
        if (!this.pulse) {
            return;
        }
        this.pulseTime += (float)this.pulseSpeed / 1000.0f;
        this.brightness = (float)((Math.sin((double)(this.pulseTime * 2.0f) * Math.PI) + 1.0) / 2.0);
        WalksyLibColor newColor = WalksyLibColor.getHSBColor(this.hue, this.saturation, this.brightness);
        WalksyLibColor newColorAlpha = new WalksyLibColor(newColor.getRed(), newColor.getGreen(), newColor.getBlue(), this.getAlpha());
        this.value = newColorAlpha.getRGB();
    }

    public static WalksyLibColor getHSBColor(float h, float s, float b) {
        return new WalksyLibColor(WalksyLibColor.HSBtoRGB(h, s, b));
    }

    public int getRGB() {
        return this.value;
    }

    public int getRed() {
        return this.getRGB() >> 16 & 0xFF;
    }

    public int getGreen() {
        return this.getRGB() >> 8 & 0xFF;
    }

    public int getBlue() {
        return this.getRGB() >> 0 & 0xFF;
    }

    public int getAlpha() {
        return this.getRGB() >> 24 & 0xFF;
    }

    public static int HSBtoRGB(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b << 0;
    }

    public static float[] RGBtoHSB(int r, int g, int b, float[] hsbvals) {
        float hue;
        int cmin;
        int cmax;
        if (hsbvals == null) {
            hsbvals = new float[3];
        }
        int n = cmax = r > g ? r : g;
        if (b > cmax) {
            cmax = b;
        }
        int n2 = cmin = r < g ? r : g;
        if (b < cmin) {
            cmin = b;
        }
        float brightness = (float)cmax / 255.0f;
        float saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (float)(cmax - r) / (float)(cmax - cmin);
            float greenc = (float)(cmax - g) / (float)(cmax - cmin);
            float bluec = (float)(cmax - b) / (float)(cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        hsbvals[0] = hue;
        hsbvals[1] = saturation;
        hsbvals[2] = brightness;
        return hsbvals;
    }

    public WalksyLibColor copy() {
        WalksyLibColor copy = new WalksyLibColor(this.getRed(), this.getGreen(), this.getBlue(), this.getAlpha());
        copy.hue = this.hue;
        copy.saturation = this.saturation;
        copy.brightness = this.brightness;
        copy.rainbow = this.rainbow;
        copy.rainbowSpeed = this.rainbowSpeed;
        copy.pulse = this.pulse;
        copy.pulseSpeed = this.pulseSpeed;
        copy.pulseTime = this.pulseTime;
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WalksyLibColor)) {
            return false;
        }
        WalksyLibColor other = (WalksyLibColor)obj;
        if (this.rainbowSpeed != other.rainbowSpeed) {
            return false;
        }
        if (this.rainbow != other.rainbow) {
            return false;
        }
        if (this.pulseSpeed != other.pulseSpeed) {
            return false;
        }
        if (this.pulse != other.pulse) {
            return false;
        }
        if (this.brightness != other.brightness && !this.pulse) {
            return false;
        }
        if (this.saturation != other.saturation) {
            return false;
        }
        return this.value == other.value || this.rainbow || this.pulse;
    }

    public static class Additions {
        public float hue;
        public float saturation;
        public float brightness;
        public boolean rainbow;
        public int rainbowSpeed;
        public boolean pulse;
        public int pulseSpeed;

        public Additions(float hue, float saturation, float brightness, boolean rainbow, int rainbowSpeed, boolean pulse, int pulseSpeed) {
            this.hue = hue;
            this.saturation = saturation;
            this.brightness = brightness;
            this.rainbow = rainbow;
            this.rainbowSpeed = rainbowSpeed;
            this.pulse = pulse;
            this.pulseSpeed = pulseSpeed;
        }
    }
}

